/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.MappedEncoding;
import de.intarsys.pdf.font.PDFont;
import java.util.Iterator;

public class DifferenceEncoding
extends Encoding {
    public static final COSName DK_Differences = COSName.constant("Differences");
    public static final COSName DK_BaseEncoding = COSName.constant("BaseEncoding");
    private final COSDictionary dict;
    private Encoding baseEncoding;
    private MappedEncoding differenceEncoding;

    public static Encoding create(COSDictionary dict, PDFont font) {
        DifferenceEncoding encoding = new DifferenceEncoding(dict);
        COSObject base = dict.get(DK_BaseEncoding);
        Encoding baseEncoding = null;
        if (base.isNull()) {
            baseEncoding = font.createDefaultEncoding();
        }
        if (base instanceof COSName) {
            baseEncoding = Encoding.createNamed((COSName)base);
        }
        encoding.setBaseEncoding(baseEncoding);
        MappedEncoding differenceEncoding = new MappedEncoding();
        encoding.setDifferenceEncoding(differenceEncoding);
        COSArray differences = dict.get(DK_Differences).asArray();
        if (differences != null) {
            int start = -1;
            Iterator it = differences.iterator();
            while (it.hasNext()) {
                COSObject element = (COSObject)it.next();
                if (element instanceof COSNumber) {
                    start = ((COSNumber)element).intValue();
                }
                if (!(element instanceof COSName) || start <= -1) continue;
                String name = ((COSName)element).stringValue();
                differenceEncoding.addEncoding(start, name);
                ++start;
            }
        }
        return encoding;
    }

    protected DifferenceEncoding(COSDictionary dict) {
        this.dict = dict;
    }

    protected COSDictionary cosGetDict() {
        return this.dict;
    }

    public COSObject cosGetObject() {
        return this.cosGetDict();
    }

    protected Encoding getBaseEncoding() {
        return this.baseEncoding;
    }

    public int getDecoded(int codepoint) {
        int code = this.getDifferenceEncoding().getDecoded(codepoint);
        if (code == -1) {
            code = this.getBaseEncoding().getDecoded(codepoint);
        }
        return code;
    }

    public int getDifferenceDecoded(int codePoint) {
        int code = this.getDifferenceEncoding().getDecoded(codePoint);
        if (code == -1) {
            return codePoint;
        }
        return code;
    }

    protected MappedEncoding getDifferenceEncoding() {
        return this.differenceEncoding;
    }

    public String getDifferenceGlyphName(int codePoint) {
        String name = this.getDifferenceEncoding().getGlyphName(codePoint);
        if (name == null || name.equals(".notdef")) {
            return null;
        }
        return name;
    }

    public int getEncoded(int character) {
        int code = this.getDifferenceEncoding().getEncoded(character);
        if (code == -1) {
            code = this.getBaseEncoding().getEncoded(character);
        }
        return code;
    }

    public int getEncoded(String name) {
        int code = this.getDifferenceEncoding().getEncoded(name);
        if (code == -1) {
            code = this.getBaseEncoding().getEncoded(name);
        }
        return code;
    }

    public String getGlyphName(int codePoint) {
        String name = this.getDifferenceEncoding().getGlyphName(codePoint);
        if (name == null || name == ".notdef") {
            name = this.getBaseEncoding().getGlyphName(codePoint);
        }
        return name;
    }

    public String getName() {
        return "DifferenceEncoding";
    }

    public boolean isFontSpecificEncoding() {
        return this.getBaseEncoding().isFontSpecificEncoding();
    }

    private void setBaseEncoding(Encoding newBaseEncoding) {
        this.baseEncoding = newBaseEncoding;
    }

    protected void setDifferenceEncoding(MappedEncoding newDifferenceEncoding) {
        this.differenceEncoding = newDifferenceEncoding;
    }
}

