/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.core.TwitterUtils;
import adams.flow.source.AbstractSource;
import java.util.Vector;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Tweet;
import twitter4j.Twitter;

public class TwitterQuery
extends AbstractSource {
    private static final long serialVersionUID = -1959430342987913960L;
    protected String m_Query;
    protected int m_ResultsPerPage;
    protected int m_MaxTweets;
    protected Vector<Tweet> m_Queue;
    protected Twitter m_Twitter;
    protected Query m_TwitterQuery;
    protected QueryResult m_QueryResult;
    protected int m_Count;
    protected Long m_LastId;

    public String globalInfo() {
        return "Outputs tweet messages.\nFor more information on twitter queries, see the following web page:\nhttp://search.twitter.com/operators";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("query", "query", (Object)"search term");
        this.m_OptionManager.add("results-per-page", "resultsPerPage", (Object)20, (Number)10, (Number)100);
        this.m_OptionManager.add("max-tweets", "maxTweets", (Object)100, (Number)1, null);
    }

    protected void initialize() {
        super.initialize();
        this.m_Queue = new Vector();
    }

    protected void reset() {
        super.reset();
        this.m_Queue.clear();
        this.m_LastId = null;
        this.m_Twitter = null;
        this.m_TwitterQuery = null;
        this.m_QueryResult = null;
    }

    public String getQuickInfo() {
        String result = "query: ";
        String variable = this.getOptionManager().getVariableForProperty("query");
        result = variable != null ? result + variable : (this.m_Query != null ? result + "\"" + this.m_Query + "\"" : result + "<none>");
        result = result + ", max tweets: ";
        variable = this.getOptionManager().getVariableForProperty("maxTweets");
        result = variable != null ? result + variable : result + this.m_MaxTweets;
        return result;
    }

    public Class[] generates() {
        return new Class[]{Tweet.class};
    }

    public void setQuery(String value) {
        this.m_Query = value;
    }

    public String getQuery() {
        return this.m_Query;
    }

    public String queryTipText() {
        return "The query for obtaining the tweets.";
    }

    public void setResultsPerPage(int value) {
        this.m_ResultsPerPage = value;
    }

    public int getResultsPerPage() {
        return this.m_ResultsPerPage;
    }

    public String resultsPerPageTipText() {
        return "The number of results per page when querying twitter.";
    }

    public void setMaxTweets(int value) {
        this.m_MaxTweets = value;
    }

    public int getMaxTweets() {
        return this.m_MaxTweets;
    }

    public String maxTweetsTipText() {
        return "The maximum number of tweets to output.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performQuery() throws Exception {
        if (this.isDebugOn()) {
            this.debug("--> Querying twitter...");
        }
        if (this.m_LastId != null) {
            long maxID = this.m_LastId - 1L;
            this.m_TwitterQuery.setMaxId(maxID);
            if (this.isDebugOn()) {
                this.debug("max ID: " + maxID);
            }
        }
        if (this.isDebugOn()) {
            this.debug("Sending query...");
        }
        Twitter twitter = this.m_Twitter;
        synchronized (twitter) {
            this.m_QueryResult = this.m_Twitter.search(this.m_TwitterQuery);
        }
        if (this.isDebugOn()) {
            this.debug("Query completed in " + this.m_QueryResult.getCompletedIn() + "s");
        }
        for (Tweet tweet : this.m_QueryResult.getTweets()) {
            if (this.isDebugOn()) {
                this.debug("tweet ID: " + tweet.getId(), 2);
            }
            this.m_Queue.add(tweet);
            ++this.m_Count;
            if (this.m_Count >= this.m_MaxTweets) {
                this.m_Twitter = null;
                if (!this.isDebugOn()) break;
                this.debug("count >= max msg");
                break;
            }
            this.m_LastId = tweet.getId();
        }
        if (this.isDebugOn()) {
            this.debug("# of tweets: " + this.m_Queue.size());
            this.debug("Querying twitter finished!");
        }
    }

    protected String doExecute() {
        String result = null;
        this.m_Count = 0;
        this.m_LastId = null;
        this.m_Twitter = TwitterUtils.getTwitterConnection((AbstractActor)this);
        this.m_TwitterQuery = new Query(this.m_Query);
        this.m_TwitterQuery.setRpp(this.m_ResultsPerPage);
        try {
            this.performQuery();
        }
        catch (Exception e) {
            this.getSystemErr().println("Failed to query twitter:");
            this.getSystemErr().printStackTrace((Throwable)e);
            result = "Error querying twitter: " + e;
        }
        return result;
    }

    public Token output() {
        Token result = null;
        if (this.m_Queue.size() == 0 && this.m_Twitter != null) {
            try {
                this.performQuery();
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to query twitter:");
                this.getSystemErr().printStackTrace((Throwable)e);
            }
        }
        if (this.m_Queue.size() > 0) {
            result = new Token((Object)this.m_Queue.get(0));
            this.m_Queue.remove(0);
        } else {
            this.m_Twitter = null;
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Twitter != null || this.m_Queue.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution() {
        if (this.m_Twitter != null) {
            Twitter twitter = this.m_Twitter;
            synchronized (twitter) {
                this.m_Twitter = null;
            }
        }
        if (this.m_Queue != null) {
            this.m_Queue.clear();
        }
        super.stopExecution();
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_Queue = null;
        this.m_Twitter = null;
        this.m_TwitterQuery = null;
        this.m_QueryResult = null;
    }
}

