/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.associations.ItemSet;
import weka.core.ContingencyTables;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class AprioriItemSet
extends ItemSet
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = 7684467755712672058L;

    public AprioriItemSet(int totalTrans) {
        super(totalTrans);
    }

    public static double confidenceForRule(AprioriItemSet premise, AprioriItemSet consequence) {
        return (double)consequence.m_counter / (double)premise.m_counter;
    }

    public double liftForRule(AprioriItemSet premise, AprioriItemSet consequence, int consequenceCount) {
        double confidence = AprioriItemSet.confidenceForRule(premise, consequence);
        return confidence / ((double)consequenceCount / (double)this.m_totalTransactions);
    }

    public double leverageForRule(AprioriItemSet premise, AprioriItemSet consequence, int premiseCount, int consequenceCount) {
        double coverageForItemSet = (double)consequence.m_counter / (double)this.m_totalTransactions;
        double expectedCoverageIfIndependent = (double)premiseCount / (double)this.m_totalTransactions * ((double)consequenceCount / (double)this.m_totalTransactions);
        double lev = coverageForItemSet - expectedCoverageIfIndependent;
        return lev;
    }

    public double convictionForRule(AprioriItemSet premise, AprioriItemSet consequence, int premiseCount, int consequenceCount) {
        double num = (double)premiseCount * (double)(this.m_totalTransactions - consequenceCount) / (double)this.m_totalTransactions;
        double denom = premiseCount - consequence.m_counter + 1;
        if (num < 0.0 || denom < 0.0) {
            System.err.println("*** " + num + " " + denom);
            System.err.println("premis count: " + premiseCount + " consequence count " + consequenceCount + " total trans " + this.m_totalTransactions);
        }
        return num / denom;
    }

    public FastVector[] generateRules(double minConfidence, FastVector hashtables, int numItemsInSet) {
        int i;
        FastVector<AprioriItemSet> premises = new FastVector<AprioriItemSet>();
        FastVector<AprioriItemSet> consequences = new FastVector<AprioriItemSet>();
        FastVector<Double> conf = new FastVector<Double>();
        FastVector<Double> lift = new FastVector<Double>();
        FastVector<Double> lev = new FastVector<Double>();
        FastVector<Double> conv = new FastVector<Double>();
        FastVector[] rules = new FastVector[6];
        Hashtable hashtable = (Hashtable)hashtables.elementAt(numItemsInSet - 2);
        for (i = 0; i < this.m_items.length; ++i) {
            if (this.m_items[i] == -1) continue;
            AprioriItemSet premise = new AprioriItemSet(this.m_totalTransactions);
            AprioriItemSet consequence = new AprioriItemSet(this.m_totalTransactions);
            premise.m_items = new int[this.m_items.length];
            consequence.m_items = new int[this.m_items.length];
            consequence.m_counter = this.m_counter;
            for (int j = 0; j < this.m_items.length; ++j) {
                consequence.m_items[j] = -1;
            }
            System.arraycopy(this.m_items, 0, premise.m_items, 0, this.m_items.length);
            premise.m_items[i] = -1;
            consequence.m_items[i] = this.m_items[i];
            premise.m_counter = (Integer)hashtable.get(premise);
            Hashtable hashtableForConsequence = (Hashtable)hashtables.elementAt(0);
            int consequenceUnconditionedCounter = (Integer)hashtableForConsequence.get(consequence);
            premises.addElement(premise);
            consequences.addElement(consequence);
            conf.addElement(new Double(AprioriItemSet.confidenceForRule(premise, consequence)));
            double tempLift = this.liftForRule(premise, consequence, consequenceUnconditionedCounter);
            double tempLev = this.leverageForRule(premise, consequence, premise.m_counter, consequenceUnconditionedCounter);
            double tempConv = this.convictionForRule(premise, consequence, premise.m_counter, consequenceUnconditionedCounter);
            lift.addElement(new Double(tempLift));
            lev.addElement(new Double(tempLev));
            conv.addElement(new Double(tempConv));
        }
        rules[0] = premises;
        rules[1] = consequences;
        rules[2] = conf;
        rules[3] = lift;
        rules[4] = lev;
        rules[5] = conv;
        AprioriItemSet.pruneRules(rules, minConfidence);
        FastVector[] moreResults = this.moreComplexRules(rules, numItemsInSet, 1, minConfidence, hashtables);
        if (moreResults != null) {
            for (i = 0; i < moreResults[0].size(); ++i) {
                rules[0].addElement(moreResults[0].elementAt(i));
                rules[1].addElement(moreResults[1].elementAt(i));
                rules[2].addElement(moreResults[2].elementAt(i));
                rules[3].addElement(moreResults[3].elementAt(i));
                rules[4].addElement(moreResults[4].elementAt(i));
                rules[5].addElement(moreResults[5].elementAt(i));
            }
        }
        return rules;
    }

    public final FastVector[] generateRulesBruteForce(double minMetric, int metricType, FastVector hashtables, int numItemsInSet, int numTransactions, double significanceLevel) throws Exception {
        FastVector<AprioriItemSet> premises = new FastVector<AprioriItemSet>();
        FastVector<AprioriItemSet> consequences = new FastVector<AprioriItemSet>();
        FastVector<Double> conf = new FastVector<Double>();
        FastVector<Double> lift = new FastVector<Double>();
        FastVector<Double> lev = new FastVector<Double>();
        FastVector<Double> conv = new FastVector<Double>();
        FastVector[] rules = new FastVector[6];
        double[][] contingencyTable = new double[2][2];
        int max = (int)Math.pow(2.0, numItemsInSet);
        for (int j = 1; j < max; ++j) {
            double metric;
            int help;
            int numItemsInPremise = 0;
            for (help = j; help > 0; help /= 2) {
                if (help % 2 != 1) continue;
                ++numItemsInPremise;
            }
            if (numItemsInPremise >= numItemsInSet) continue;
            Hashtable hashtableForPremise = (Hashtable)hashtables.elementAt(numItemsInPremise - 1);
            Hashtable hashtableForConsequence = (Hashtable)hashtables.elementAt(numItemsInSet - numItemsInPremise - 1);
            AprioriItemSet premise = new AprioriItemSet(this.m_totalTransactions);
            AprioriItemSet consequence = new AprioriItemSet(this.m_totalTransactions);
            premise.m_items = new int[this.m_items.length];
            consequence.m_items = new int[this.m_items.length];
            consequence.m_counter = this.m_counter;
            help = j;
            for (int i = 0; i < this.m_items.length; ++i) {
                if (this.m_items[i] != -1) {
                    if (help % 2 == 1) {
                        premise.m_items[i] = this.m_items[i];
                        consequence.m_items[i] = -1;
                    } else {
                        premise.m_items[i] = -1;
                        consequence.m_items[i] = this.m_items[i];
                    }
                    help /= 2;
                    continue;
                }
                premise.m_items[i] = -1;
                consequence.m_items[i] = -1;
            }
            premise.m_counter = (Integer)hashtableForPremise.get(premise);
            int consequenceUnconditionedCounter = (Integer)hashtableForConsequence.get(consequence);
            if (metricType == 0) {
                contingencyTable[0][0] = consequence.m_counter;
                contingencyTable[0][1] = premise.m_counter - consequence.m_counter;
                contingencyTable[1][0] = consequenceUnconditionedCounter - consequence.m_counter;
                contingencyTable[1][1] = numTransactions - premise.m_counter - consequenceUnconditionedCounter + consequence.m_counter;
                double chiSquared = ContingencyTables.chiSquared(contingencyTable, false);
                metric = AprioriItemSet.confidenceForRule(premise, consequence);
                if (metric < minMetric || chiSquared > significanceLevel) continue;
                premises.addElement(premise);
                consequences.addElement(consequence);
                conf.addElement(new Double(metric));
                lift.addElement(new Double(this.liftForRule(premise, consequence, consequenceUnconditionedCounter)));
                lev.addElement(new Double(this.leverageForRule(premise, consequence, premise.m_counter, consequenceUnconditionedCounter)));
                conv.addElement(new Double(this.convictionForRule(premise, consequence, premise.m_counter, consequenceUnconditionedCounter)));
                continue;
            }
            double tempConf = AprioriItemSet.confidenceForRule(premise, consequence);
            double tempLift = this.liftForRule(premise, consequence, consequenceUnconditionedCounter);
            double tempLev = this.leverageForRule(premise, consequence, premise.m_counter, consequenceUnconditionedCounter);
            double tempConv = this.convictionForRule(premise, consequence, premise.m_counter, consequenceUnconditionedCounter);
            switch (metricType) {
                case 1: {
                    metric = tempLift;
                    break;
                }
                case 2: {
                    metric = tempLev;
                    break;
                }
                case 3: {
                    metric = tempConv;
                    break;
                }
                default: {
                    throw new Exception("ItemSet: Unknown metric type!");
                }
            }
            if (metric < minMetric) continue;
            premises.addElement(premise);
            consequences.addElement(consequence);
            conf.addElement(new Double(tempConf));
            lift.addElement(new Double(tempLift));
            lev.addElement(new Double(tempLev));
            conv.addElement(new Double(tempConv));
        }
        rules[0] = premises;
        rules[1] = consequences;
        rules[2] = conf;
        rules[3] = lift;
        rules[4] = lev;
        rules[5] = conv;
        return rules;
    }

    public final AprioriItemSet subtract(AprioriItemSet toSubtract) {
        AprioriItemSet result = new AprioriItemSet(this.m_totalTransactions);
        result.m_items = new int[this.m_items.length];
        for (int i = 0; i < this.m_items.length; ++i) {
            result.m_items[i] = toSubtract.m_items[i] == -1 ? this.m_items[i] : -1;
        }
        result.m_counter = 0;
        return result;
    }

    private final FastVector[] moreComplexRules(FastVector[] rules, int numItemsInSet, int numItemsInConsequence, double minConfidence, FastVector hashtables) {
        FastVector<AprioriItemSet> newPremises = new FastVector<AprioriItemSet>();
        FastVector<Double> newConf = new FastVector<Double>();
        FastVector<Double> newLift = null;
        FastVector<Double> newLev = null;
        FastVector<Double> newConv = null;
        newLift = new FastVector<Double>();
        newLev = new FastVector<Double>();
        newConv = new FastVector<Double>();
        if (numItemsInSet > numItemsInConsequence + 1) {
            Hashtable hashtable = (Hashtable)hashtables.elementAt(numItemsInSet - numItemsInConsequence - 2);
            FastVector newConsequences = AprioriItemSet.mergeAllItemSets(rules[1], numItemsInConsequence - 1, this.m_totalTransactions);
            int newNumInConsequence = numItemsInConsequence + 1;
            Hashtable hashtableForConsequence = (Hashtable)hashtables.elementAt(newNumInConsequence - 1);
            Enumeration enu = newConsequences.elements();
            while (enu.hasMoreElements()) {
                AprioriItemSet current = (AprioriItemSet)enu.nextElement();
                int z = 0;
                for (int jj = 0; jj < current.m_items.length; ++jj) {
                    if (current.m_items[jj] == -1) continue;
                    ++z;
                }
                current.m_counter = this.m_counter;
                AprioriItemSet newPremise = this.subtract(current);
                newPremise.m_counter = (Integer)hashtable.get(newPremise);
                newPremises.addElement(newPremise);
                newConf.addElement(new Double(AprioriItemSet.confidenceForRule(newPremise, current)));
                int consequenceUnconditionedCounter = (Integer)hashtableForConsequence.get(current);
                double tempLift = this.liftForRule(newPremise, current, consequenceUnconditionedCounter);
                double tempLev = this.leverageForRule(newPremise, current, newPremise.m_counter, consequenceUnconditionedCounter);
                double tempConv = this.convictionForRule(newPremise, current, newPremise.m_counter, consequenceUnconditionedCounter);
                newLift.addElement(new Double(tempLift));
                newLev.addElement(new Double(tempLev));
                newConv.addElement(new Double(tempConv));
            }
            FastVector[] result = new FastVector[rules.length];
            result[0] = newPremises;
            result[1] = newConsequences;
            result[2] = newConf;
            result[3] = newLift;
            result[4] = newLev;
            result[5] = newConv;
            AprioriItemSet.pruneRules(result, minConfidence);
            FastVector[] moreResults = this.moreComplexRules(result, numItemsInSet, numItemsInConsequence + 1, minConfidence, hashtables);
            if (moreResults != null) {
                for (int i = 0; i < moreResults[0].size(); ++i) {
                    result[0].addElement(moreResults[0].elementAt(i));
                    result[1].addElement(moreResults[1].elementAt(i));
                    result[2].addElement(moreResults[2].elementAt(i));
                    result[3].addElement(moreResults[3].elementAt(i));
                    result[4].addElement(moreResults[4].elementAt(i));
                    result[5].addElement(moreResults[5].elementAt(i));
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public final String toString(Instances instances) {
        return super.toString(instances);
    }

    public static FastVector singletons(Instances instances, boolean treatZeroAsMissing) throws Exception {
        FastVector<AprioriItemSet> setOfItemSets = new FastVector<AprioriItemSet>();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            int j;
            if (instances.attribute(i).isNumeric()) {
                throw new Exception("Can't handle numeric attributes!");
            }
            int n = j = treatZeroAsMissing ? 1 : 0;
            while (j < instances.attribute(i).numValues()) {
                AprioriItemSet current = new AprioriItemSet(instances.numInstances());
                current.setTreatZeroAsMissing(treatZeroAsMissing);
                current.m_items = new int[instances.numAttributes()];
                for (int k = 0; k < instances.numAttributes(); ++k) {
                    current.m_items[k] = -1;
                }
                current.m_items[i] = j++;
                setOfItemSets.addElement(current);
            }
        }
        return setOfItemSets;
    }

    public static FastVector mergeAllItemSets(FastVector itemSets, int size, int totalTrans) {
        FastVector<AprioriItemSet> newVector = new FastVector<AprioriItemSet>();
        block0: for (int i = 0; i < itemSets.size(); ++i) {
            ItemSet first = (ItemSet)itemSets.elementAt(i);
            for (int j = i + 1; j < itemSets.size(); ++j) {
                ItemSet second = (ItemSet)itemSets.elementAt(j);
                AprioriItemSet result = new AprioriItemSet(totalTrans);
                result.m_items = new int[first.m_items.length];
                int numFound = 0;
                int k = 0;
                while (numFound < size) {
                    if (first.m_items[k] != second.m_items[k]) continue block0;
                    if (first.m_items[k] != -1) {
                        ++numFound;
                    }
                    result.m_items[k] = first.m_items[k];
                    ++k;
                }
                while (k < first.m_items.length && (first.m_items[k] == -1 || second.m_items[k] == -1)) {
                    result.m_items[k] = first.m_items[k] != -1 ? first.m_items[k] : second.m_items[k];
                    ++k;
                }
                if (k != first.m_items.length) continue;
                result.m_counter = 0;
                newVector.addElement(result);
            }
        }
        return newVector;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6555 $");
    }
}

