/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.BaseString;
import org.apache.commons.codec.binary.Base64;

public class BasePassword
extends BaseString {
    private static final long serialVersionUID = -3626665478868498359L;
    public static final String BASE64_START = "{";
    public static final String BASE64_END = "}";
    public static final String ERROR = "-ERROR-";
    public static final String MASK_CHAR = "*";

    public BasePassword() {
        this("");
    }

    public BasePassword(String s) {
        super(s);
    }

    protected String decode(String base64) {
        String result;
        try {
            result = new String(Base64.decodeBase64((byte[])base64.substring(1, base64.length() - 1).getBytes()));
        }
        catch (Exception e) {
            System.err.println("Failed to decode base64 string: " + base64);
            e.printStackTrace();
            result = ERROR;
        }
        return result;
    }

    protected String encode(String raw) {
        return BASE64_START + Base64.encodeBase64String((byte[])raw.getBytes()) + BASE64_END;
    }

    @Override
    public boolean isValid(String value) {
        if (value.startsWith(BASE64_START)) {
            return value.endsWith(BASE64_END);
        }
        return true;
    }

    @Override
    public void setValue(String value) {
        if (!this.isValid(value)) {
            return;
        }
        this.m_Internal = value.startsWith(BASE64_START) ? this.decode(value) : value;
    }

    @Override
    public String getValue() {
        return (String)((Object)this.m_Internal);
    }

    public String getMaskedValue() {
        return this.getValue().replaceAll(".", MASK_CHAR);
    }

    @Override
    public String stringValue() {
        return this.encode(this.getValue());
    }

    @Override
    public String getTipText() {
        return "For handling passwords.";
    }
}

