/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.io.PlaceholderDirectory;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class DirectoryExists
extends AbstractBooleanCondition {
    private static final long serialVersionUID = 912094591109587908L;
    protected PlaceholderDirectory m_Directory;

    @Override
    public String globalInfo() {
        return "Emulates an If-Then-Else construct. The 'Then' branch gets executed if the directory exists, otherwise the 'Else' branch.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("directory", "directory", new PlaceholderDirectory("."));
    }

    public void setDirectory(PlaceholderDirectory value) {
        this.m_Directory = value;
        this.reset();
    }

    public PlaceholderDirectory getDirectory() {
        return this.m_Directory;
    }

    public String directoryTipText() {
        return "The directory to look for.";
    }

    @Override
    public String getQuickInfo() {
        String result = "dir: ";
        String variable = this.getOptionManager().getVariableForProperty("directory");
        result = variable != null ? result + variable : result + this.m_Directory.toString();
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = null;
        if (this.m_Directory == null) {
            result = "No directory provided!";
        }
        return result;
    }

    @Override
    protected boolean doEvaluate(AbstractActor owner, Token token) {
        return this.m_Directory.exists() && this.m_Directory.isDirectory();
    }
}

