/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.AbstractControlActor;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.sink.Null;
import java.util.Hashtable;

public abstract class AbstractTee
extends AbstractControlActor
implements InputConsumer,
OutputProducer,
MutableActorHandler {
    private static final long serialVersionUID = 7132280825125548047L;
    public static final String BACKUP_INPUT = "input";
    protected Sequence m_Actors;
    protected transient Token m_InputToken;
    protected transient Token m_OutputToken;
    protected int m_MinimumActiveActors;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tee", "actors", new AbstractActor[0]);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Actors = new Sequence();
        this.m_Actors.setActors(new AbstractActor[]{new Null()});
        this.m_MinimumActiveActors = 1;
    }

    @Override
    public String check() {
        return this.checkTeeActors(this.getActors());
    }

    protected abstract String checkTeeActor(int var1, AbstractActor var2);

    protected abstract String checkTeeActors(AbstractActor[] var1);

    public void setActors(AbstractActor[] value) {
        String msg = this.checkTeeActors(value);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.setActors(value);
        this.reset();
        this.updateParent();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.getActors();
    }

    public String actorsTipText() {
        return "The actors to siphon-off the tokens to.";
    }

    @Override
    protected void updateParent() {
        this.m_Actors.setName(this.getName());
        this.m_Actors.setParent(null);
        this.m_Actors.setParent(this.getParent());
    }

    @Override
    public int size() {
        return this.m_Actors.size();
    }

    @Override
    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        String msg = this.checkTeeActor(index, actor);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.set(index, actor);
        this.reset();
        this.updateParent();
    }

    @Override
    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    @Override
    public void add(int index, AbstractActor actor) {
        String msg = this.checkTeeActor(index, actor);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.add(index, actor);
        this.reset();
        this.updateParent();
    }

    @Override
    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    @Override
    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    protected abstract String setUpTeeActors();

    @Override
    protected void reset() {
        super.reset();
        this.m_InputToken = null;
        this.m_OutputToken = null;
    }

    public void setMinimumActiveActors(int value) {
        this.m_MinimumActiveActors = value;
    }

    public int getMinimumActiveActors() {
        return this.m_MinimumActiveActors;
    }

    @Override
    protected String setUpSubActors() {
        String result = null;
        if (this.m_Actors.active() < this.getMinimumActiveActors()) {
            result = "Not enough (active) tee-actors provided; required " + this.getMinimumActiveActors() + ", found " + this.m_Actors.active();
        }
        if (result == null && !this.getSkip()) {
            this.updateParent();
            result = this.setUpTeeActors();
            if (result == null) {
                result = this.m_Actors.setUp();
            }
        }
        return result;
    }

    protected Token createTeeToken(Token token) {
        return token;
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
    }

    protected boolean canProcessInput(Token token) {
        return true;
    }

    protected String processInput(Token token) {
        String result;
        try {
            this.m_Actors.input(this.createTeeToken(token));
            result = this.m_Actors.execute();
        }
        catch (Exception e) {
            String msg = this.m_Actors.getFullName() + " generated following exception: ";
            result = msg + e;
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.canProcessInput(this.m_InputToken)) {
            if (this.isDebugOn()) {
                this.debug("Teeing off: " + this.m_InputToken.getPayload());
            }
            if ((result = this.processInput(this.m_InputToken)) != null) {
                this.handleError("tee", result);
            }
        }
        this.m_OutputToken = this.m_InputToken;
        this.m_InputToken = null;
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    @Override
    public void stopExecution() {
        super.stopExecution();
        this.m_Actors.stopExecution();
    }

    @Override
    public void wrapUp() {
        this.m_Actors.wrapUp();
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        this.m_Actors.cleanUp();
        super.cleanUp();
    }
}

