/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Vector;

public class SetReportFromFile
extends AbstractTransformer {
    private static final long serialVersionUID = -8951982264797087668L;
    protected PlaceholderFile m_ReportFile;
    protected AbstractReportReader m_Reader;

    @Override
    public String globalInfo() {
        return "Loads a report from disk and replaces the current one in the token passing through.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("report-file", "reportFile", new PlaceholderFile("."));
        this.m_OptionManager.add("reader", "reader", this.getDefaultReader());
    }

    public void setReportFile(PlaceholderFile value) {
        this.m_ReportFile = value;
        this.reset();
    }

    public PlaceholderFile getReportFile() {
        return this.m_ReportFile;
    }

    public String reportFileTipText() {
        return "The file to load the report from.";
    }

    protected AbstractReportReader getDefaultReader() {
        return new DefaultSimpleReportReader();
    }

    public void setReader(AbstractReportReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractReportReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for loading the report.";
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("reportFile");
        if (variable != null) {
            return variable;
        }
        return this.m_ReportFile.toString();
    }

    @Override
    public Class[] accepts() {
        return new Class[]{MutableReportHandler.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{MutableReportHandler.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && this.getOptionManager().getVariableForProperty("reportFile") == null) {
            if (this.m_ReportFile.isDirectory()) {
                result = "Report file '" + this.m_ReportFile + "' points to a directory!";
            } else if (!this.m_ReportFile.exists()) {
                result = "Report file '" + this.m_ReportFile + "' does not exist!";
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        MutableReportHandler handler = (MutableReportHandler)this.m_InputToken.getPayload();
        this.m_Reader.setInput(this.m_ReportFile);
        Vector reports = this.m_Reader.read();
        if (reports.size() > 0) {
            if (reports.size() > 1) {
                this.getSystemErr().println("WARNING: report file '" + this.m_ReportFile + "' contains more than one report, using only first report!");
            }
            handler.setReport((Report)reports.get(0));
        } else {
            result = "Not able to extract a report from file '" + this.m_ReportFile + "'!";
        }
        if (result == null) {
            this.m_OutputToken = new Token(handler);
        }
        return result;
    }
}

