/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.JListHelper;
import adams.gui.event.RemoveItemsEvent;
import adams.gui.event.RemoveItemsListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;

public class BaseList
extends JList {
    private static final long serialVersionUID = -3859605644790923061L;
    protected HashSet<RemoveItemsListener> m_RemoveItemsListeners;

    public BaseList() {
        this.initGUI();
    }

    public BaseList(Object[] listData) {
        super(listData);
        this.initGUI();
    }

    public BaseList(Vector<?> listData) {
        super(listData);
        this.initGUI();
    }

    public BaseList(ListModel dataModel) {
        super(dataModel);
        this.setModel(this.getModel());
        this.initGUI();
    }

    protected void initGUI() {
        this.m_RemoveItemsListeners = new HashSet();
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseList.this.m_RemoveItemsListeners.size() > 0 && e.getKeyCode() == 127 && e.getModifiers() == 0) {
                    e.consume();
                    BaseList.this.notifyRemoveItemsListeners(BaseList.this.getSelectedIndices());
                }
            }
        });
    }

    public void moveUp() {
        JListHelper.moveUp(this);
    }

    public void moveDown() {
        JListHelper.moveDown(this);
    }

    public void moveTop() {
        JListHelper.moveTop(this);
    }

    public void moveBottom() {
        JListHelper.moveBottom(this);
    }

    public boolean canMoveUp() {
        return JListHelper.canMoveUp(this);
    }

    public boolean canMoveDown() {
        return JListHelper.canMoveDown(this);
    }

    public void addRemoveItemsListener(RemoveItemsListener l) {
        this.m_RemoveItemsListeners.add(l);
    }

    public void removeRemoveItemsListener(RemoveItemsListener l) {
        this.m_RemoveItemsListeners.remove(l);
    }

    protected void notifyRemoveItemsListeners(int[] indices) {
        RemoveItemsEvent event = new RemoveItemsEvent(this, indices);
        for (RemoveItemsListener l : this.m_RemoveItemsListeners) {
            l.removeItems(event);
        }
    }
}

