/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.data.filter.AbstractFilter;
import adams.data.filter.PassThrough;
import adams.env.Environment;
import adams.gui.core.BaseDialog;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericArrayEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GenericArrayEditorDialog
extends BaseDialog {
    private static final long serialVersionUID = 6595810269220104762L;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    protected GenericArrayEditor m_Editor;
    protected Object m_Current;
    protected int m_Result;

    public GenericArrayEditorDialog(Dialog owner) {
        super(owner);
    }

    public GenericArrayEditorDialog(Dialog owner, Dialog.ModalityType modality) {
        super(owner, modality);
    }

    public GenericArrayEditorDialog(Dialog owner, String title) {
        super(owner, title);
    }

    public GenericArrayEditorDialog(Dialog owner, String title, Dialog.ModalityType modality) {
        super(owner, title, modality);
    }

    public GenericArrayEditorDialog(Frame owner) {
        super(owner);
    }

    public GenericArrayEditorDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    public GenericArrayEditorDialog(Frame owner, String title) {
        super(owner, title);
    }

    public GenericArrayEditorDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Editor = new GenericArrayEditor();
        this.m_Current = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_Editor, "Center");
        this.m_Editor.addOkListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditorDialog.this.m_Result = 0;
                GenericArrayEditorDialog.this.m_Current = GenericArrayEditorDialog.this.m_Editor.getValue();
                GenericArrayEditorDialog.this.setVisible(false);
            }
        });
        this.m_Editor.addCancelListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditorDialog.this.m_Result = 1;
                GenericArrayEditorDialog.this.setVisible(false);
            }
        });
        this.pack();
    }

    public GenericArrayEditor getEditor() {
        return this.m_Editor;
    }

    @Override
    protected void beforeShow() {
        super.beforeShow();
        this.m_Current = this.m_Editor.getValue();
        this.m_Result = 1;
        GUIHelper.adjustSize(this);
    }

    public void setCurrent(Object value) {
        this.m_Editor.setValue(value);
        this.m_Current = value;
        GUIHelper.adjustSize(this);
    }

    public Object getCurrent() {
        return this.m_Current;
    }

    public int getResult() {
        return this.m_Result;
    }

    public static GenericArrayEditorDialog createDialog(Container parent) {
        return GenericArrayEditorDialog.createDialog(parent, null);
    }

    public static GenericArrayEditorDialog createDialog(Container parent, Object value) {
        GenericArrayEditorDialog result = GUIHelper.getParentDialog(parent) != null ? new GenericArrayEditorDialog(GUIHelper.getParentDialog(parent)) : new GenericArrayEditorDialog(GUIHelper.getParentFrame(parent));
        result.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        result.setTitle("Array editor");
        if (value != null) {
            result.setCurrent(value);
        }
        return result;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GenericArrayEditorDialog dialog = new GenericArrayEditorDialog((Frame)null, "Array editor", true);
        dialog.setDefaultCloseOperation(2);
        dialog.setCurrent(new AbstractFilter[]{new PassThrough()});
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        if (dialog.getResult() == 0) {
            System.out.println(Utils.arrayToString(dialog.getCurrent()));
        }
    }
}

