/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.report;

import adams.core.DateFormat;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.container.ColorContainer;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.container.VisibilityContainerManager;
import adams.gui.visualization.core.AbstractPaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.plot.Axis;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Date;
import java.util.HashSet;

public class ReportDateFieldPaintlet
extends AbstractPaintlet
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 4296847364394457330L;
    protected Field m_Field;
    protected String m_Format;
    protected String m_Prefix;
    protected transient DateFormat m_DateFormat;
    protected int m_OffsetY;
    protected int m_OffsetX;

    @Override
    public String globalInfo() {
        return "Paintlet for painting an indicator based on the date stored in a report.\nFor more details on the date format, see:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", new Field(null, DataType.STRING));
        this.m_OptionManager.add("format", "format", "yyyy-MM-dd HH:mm:ss");
        this.m_OptionManager.add("prefix", "prefix", "");
        this.m_OptionManager.add("offset-x", "offsetX", 10);
        this.m_OptionManager.add("offset-y", "offsetY", 10, 0, null);
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        return new DateFormat().getTechnicalInformation();
    }

    public void setField(Field value) {
        if (value != this.m_Field || value != null && !value.equals(this.m_Field)) {
            this.m_Field = value;
            this.memberChanged();
        }
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The date field in the report to highlight.";
    }

    public void setFormat(String value) {
        if (value != this.m_Format || value != null && !value.equals(this.m_Format)) {
            this.m_Format = value;
            this.memberChanged();
        }
    }

    public String getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The date format to use for parsing the value stored in the report.";
    }

    public void setPrefix(String value) {
        if (value != this.m_Prefix || value != null && !value.equals(this.m_Prefix)) {
            this.m_Prefix = value;
            this.memberChanged();
        }
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the date label printed next to the indicator.";
    }

    public void setOffsetX(int value) {
        if (value != this.m_OffsetX) {
            this.m_OffsetX = value;
            this.memberChanged();
        }
    }

    public int getOffsetX() {
        return this.m_OffsetX;
    }

    public String offsetXTipText() {
        return "The number of pixels to offset the string from the left of the indicator.";
    }

    public void setOffsetY(int value) {
        if (value != this.m_OffsetY && value >= 0) {
            this.m_OffsetY = value;
            this.memberChanged();
        }
    }

    public int getOffsetY() {
        return this.m_OffsetY;
    }

    public String offsetYTipText() {
        return "The number of pixels to offset the string from the top of the panel.";
    }

    @Override
    public void setPanel(PaintablePanel value) {
        if (!(value instanceof DataContainerPanel)) {
            throw new IllegalArgumentException("Panel is not derived from " + DataContainerPanel.class.getName() + "!");
        }
        super.setPanel(value);
    }

    protected synchronized DateFormat getDateFormat() {
        if (this.m_DateFormat == null) {
            this.m_DateFormat = new DateFormat(this.m_Format);
        }
        return this.m_DateFormat;
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.POST_PAINT;
    }

    @Override
    public void performPaint(Graphics g) {
        DataContainerPanel panel = (DataContainerPanel)this.getPanel();
        Object manager = panel.getContainerManager();
        DateFormat dformat = this.getDateFormat();
        HashSet<String> dates = new HashSet<String>();
        for (int i = 0; i < ((ContainerManager)manager).count(); ++i) {
            Date date;
            String dateStr;
            Object cont = ((ContainerManager)manager).get(i);
            if (manager instanceof VisibilityContainerManager && !((VisibilityContainer)cont).isVisible()) continue;
            Object report = ((Container)cont).getPayload() instanceof ReportHandler ? ((ReportHandler)((Object)((Container)cont).getPayload())).getReport() : (((Container)cont).getPayload() instanceof Report ? (Report)((Container)cont).getPayload() : null);
            Color color = cont instanceof ColorContainer ? ((ColorContainer)cont).getColor() : Color.RED;
            if (report == null || !((Report)report).hasValue(this.m_Field)) continue;
            AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
            try {
                dateStr = ((Report)report).getStringValue(this.m_Field);
                date = dformat.parse(dateStr);
            }
            catch (Exception e) {
                dateStr = null;
                date = null;
                this.getSystemErr().println("Failed to parse field '" + this.m_Field + "' using format '" + this.m_Format + "':");
                this.getSystemErr().printStackTrace(e);
            }
            if (dateStr == null || dates.contains(dateStr)) continue;
            dates.add(dateStr);
            g.setColor(color);
            g.drawLine(axisX.valueToPos(date.getTime()), 0, axisX.valueToPos(date.getTime()), this.getPanel().getHeight());
            g.drawString(this.m_Prefix + axisX.valueToDisplay(date.getTime()), axisX.valueToPos(date.getTime()) + this.m_OffsetX, this.m_OffsetY);
        }
    }
}

