/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.flow.container.AbstractContainer;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;

public class WekaClusteringContainer
extends AbstractContainer {
    private static final long serialVersionUID = -4345755816230522577L;
    public static final String VALUE_INSTANCE = "Instance";
    public static final String VALUE_CLUSTER = "Cluster";
    public static final String VALUE_DISTRIBUTION = "Distribution";
    public static final String VALUE_LOGDENSITY = "LogDensity";
    public static final String VALUE_LOGDENSITYPERCLUSTER = "LogDensityPerCluster";
    public static final String VALUE_LOGJOINTDENSITIES = "LogJointDensities";

    public WekaClusteringContainer() {
        this(null, -1, new double[0]);
    }

    public WekaClusteringContainer(Instance inst, int cluster, double[] dist) {
        this(inst, cluster, dist, 0.0, new double[0], new double[0]);
    }

    public WekaClusteringContainer(Instance inst, int cluster, double[] dist, double logDensity, double[] logDensityPerCluster, double[] logJointDensities) {
        if (inst != null) {
            this.store(VALUE_INSTANCE, (Instance)inst.copy());
        }
        this.store(VALUE_CLUSTER, cluster);
        this.store(VALUE_DISTRIBUTION, dist.clone());
        if (logDensityPerCluster.length > 0) {
            this.store(VALUE_LOGDENSITY, logDensity);
            this.store(VALUE_LOGDENSITYPERCLUSTER, logDensityPerCluster.clone());
            this.store(VALUE_LOGJOINTDENSITIES, logJointDensities.clone());
        }
    }

    public Enumeration<String> names() {
        Vector<String> result = new Vector<String>();
        result.add(VALUE_INSTANCE);
        result.add(VALUE_CLUSTER);
        result.add(VALUE_DISTRIBUTION);
        result.add(VALUE_LOGDENSITY);
        result.add(VALUE_LOGDENSITYPERCLUSTER);
        result.add(VALUE_LOGJOINTDENSITIES);
        return result.elements();
    }

    public boolean isValid() {
        return (this.hasValue(VALUE_INSTANCE) && this.hasValue(VALUE_CLUSTER) && this.hasValue(VALUE_DISTRIBUTION) && !this.hasValue(VALUE_LOGDENSITY) && !this.hasValue(VALUE_LOGDENSITYPERCLUSTER) && !this.hasValue(VALUE_LOGJOINTDENSITIES)) | (this.hasValue(VALUE_INSTANCE) && this.hasValue(VALUE_CLUSTER) && this.hasValue(VALUE_DISTRIBUTION) && this.hasValue(VALUE_LOGDENSITY) && this.hasValue(VALUE_LOGDENSITYPERCLUSTER) && this.hasValue(VALUE_LOGJOINTDENSITIES));
    }
}

