/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.InstanceComparator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class RemoveDuplicates
extends SimpleBatchFilter
implements UnsupervisedFilter,
Randomizable {
    private static final long serialVersionUID = -7024951985782351356L;
    protected boolean m_IncludeClass = false;
    protected boolean m_Randomize = false;
    protected int m_Seed = 42;

    public String globalInfo() {
        return "Removes all duplicate instances.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tWhether to include the class attribute in the comparison as well.\n", "include-class", 0, "-include-class"));
        result.addElement(new Option("\tWhether to randomize the data after the removal process.\n", "randomize", 0, "-randomize"));
        result.addElement(new Option("\tSpecifies the seed value for randomization.\n\t(default: 42)\n", "S", 1, "-S <int>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setIncludeClass(Utils.getFlag((String)"include-class", (String[])options));
        this.setRandomize(Utils.getFlag((String)"randomize", (String[])options));
        String tmpStr = Utils.getOption((char)'S', (String[])options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(42);
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        if (this.getIncludeClass()) {
            result.add("-include-class");
        }
        if (this.getRandomize()) {
            result.add("-randomize");
            result.add("-S");
            result.add("" + this.getSeed());
        }
        return result.toArray(new String[result.size()]);
    }

    public void setIncludeClass(boolean value) {
        this.m_IncludeClass = value;
    }

    public boolean getIncludeClass() {
        return this.m_IncludeClass;
    }

    public String includeClassTipText() {
        return "If enabled, the class attribute gets taken into account when comparing instances.";
    }

    public void setRandomize(boolean value) {
        this.m_Randomize = value;
    }

    public boolean getRandomize() {
        return this.m_Randomize;
    }

    public String randomizeTipText() {
        return "If enabled, the data gets randomized after the removal process.";
    }

    public void setSeed(int value) {
        this.m_Seed = value;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for randomization (if enabled).";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        Instances result = new Instances(instances);
        InstanceComparator comp = new InstanceComparator(this.m_IncludeClass);
        Collections.sort(result, comp);
        int i = 1;
        while (i < result.numInstances()) {
            if (comp.compare(result.instance(i - 1), result.instance(i)) == 0) {
                result.delete(i);
                continue;
            }
            ++i;
        }
        result.compactify();
        if (this.m_Randomize) {
            result.randomize(new Random(this.m_Seed));
        }
        if (this.m_Debug) {
            System.out.println("Reduction: " + instances.numInstances() + " -> " + result.numInstances());
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 4521 $");
    }

    public static void main(String[] args) {
        RemoveDuplicates.runFilter((Filter)new RemoveDuplicates(), (String[])args);
    }
}

