/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.IOutlet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StandardOutlet
implements IOutlet {
    private Map<String, IFactory> factories = new HashMap<String, IFactory>();

    public IFactory[] getFactories() {
        return this.factories.values().toArray(new IFactory[this.factories.size()]);
    }

    public IFactory[] lookupFactories(Class type) {
        HashSet<IFactory> result = new HashSet<IFactory>();
        for (IFactory factory : this.factories.values()) {
            Class resultType = factory.getResultType();
            if (resultType == null || !type.isAssignableFrom(resultType)) continue;
            result.add(factory);
        }
        return result.toArray(new IFactory[result.size()]);
    }

    public IFactory lookupFactory(String id) {
        return this.factories.get(id);
    }

    public void registerFactory(IFactory factory) {
        this.factories.put(factory.getId(), factory);
    }

    public void unregisterFactory(IFactory factory) {
        this.factories.remove(factory.getId());
    }
}

