/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

class BlockTransferThrottler {
    private long period;
    private long periodExtension;
    private long bytesPerPeriod;
    private long curPeriodStart = System.currentTimeMillis();
    private long curReserve;
    private long bytesAlreadyUsed;

    BlockTransferThrottler(long bandwidthPerSec) {
        this(500L, bandwidthPerSec);
    }

    BlockTransferThrottler(long period, long bandwidthPerSec) {
        this.period = period;
        this.curReserve = this.bytesPerPeriod = bandwidthPerSec * period / 1000L;
        this.periodExtension = period * 3L;
    }

    synchronized long getBandwidth() {
        return this.bytesPerPeriod * 1000L / this.period;
    }

    synchronized void setBandwidth(long bytesPerSecond) {
        if (bytesPerSecond <= 0L) {
            throw new IllegalArgumentException("" + bytesPerSecond);
        }
        this.bytesPerPeriod = bytesPerSecond * this.period / 1000L;
    }

    synchronized void throttle(long numOfBytes) {
        if (numOfBytes <= 0L) {
            return;
        }
        this.curReserve -= numOfBytes;
        this.bytesAlreadyUsed += numOfBytes;
        while (this.curReserve <= 0L) {
            long curPeriodEnd;
            long now = System.currentTimeMillis();
            if (now < (curPeriodEnd = this.curPeriodStart + this.period)) {
                try {
                    this.wait(curPeriodEnd - now);
                }
                catch (InterruptedException ignored) {}
                continue;
            }
            if (now < this.curPeriodStart + this.periodExtension) {
                this.curPeriodStart = curPeriodEnd;
                this.curReserve += this.bytesPerPeriod;
                continue;
            }
            this.curPeriodStart = now;
            this.curReserve = this.bytesPerPeriod - this.bytesAlreadyUsed;
        }
        this.bytesAlreadyUsed -= numOfBytes;
    }
}

