/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.License;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.annotation.MixedCopyright;
import adams.core.base.BasePassword;
import adams.core.io.PlaceholderFile;
import adams.flow.standalone.AbstractStandalone;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

@MixedCopyright(copyright="JCraft", license=License.BSD3, url="http://www.jcraft.com/jsch/")
public class SSHConnection
extends AbstractStandalone
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -1959430342987913960L;
    protected String m_Host;
    protected int m_Port;
    protected String m_User;
    protected BasePassword m_Password;
    protected PlaceholderFile m_KnownHosts;
    protected boolean m_ForwardX;
    protected String m_XHost;
    protected String m_XPort;
    protected Session m_Session;

    public String globalInfo() {
        return "Provides access to a remote host via SSH.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.TITLE, "JSch - JSch is a pure Java implementation of SSH2.");
        result.setValue(TechnicalInformation.Field.HTTP, "http://www.jcraft.com/jsch/");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"");
        this.m_OptionManager.add("port", "port", (Object)22, (Number)1, (Number)65535);
        this.m_OptionManager.add("user", "user", (Object)System.getProperty("user.name"));
        this.m_OptionManager.add("password", "password", (Object)new BasePassword(""));
        this.m_OptionManager.add("known-hosts", "knownHosts", (Object)new PlaceholderFile(System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "known_hosts"));
        this.m_OptionManager.add("forward-x", "forwardX", (Object)false);
        this.m_OptionManager.add("x-host", "XHost", (Object)"");
        this.m_OptionManager.add("x-port", "XPort", (Object)"0:0");
    }

    protected void reset() {
        super.reset();
        this.disconnect();
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("user");
        String result = variable != null ? variable : this.m_User;
        variable = this.getOptionManager().getVariableForProperty("password");
        result = variable != null ? result + ":" + variable : result + ":" + this.m_Password.getValue().replaceAll(".", "*");
        result = result + "@";
        variable = this.getOptionManager().getVariableForProperty("host");
        result = variable != null ? result + variable : result + this.m_Host;
        result = result + ":";
        variable = this.getOptionManager().getVariableForProperty("port");
        result = variable != null ? result + variable : result + this.m_Port;
        return result;
    }

    public void setHost(String value) {
        this.m_Host = value;
    }

    public String getHost() {
        return this.m_Host;
    }

    public String hostTipText() {
        return "The host (name/IP address) to connect to.";
    }

    public void setPort(int value) {
        this.m_Port = value;
        this.reset();
    }

    public int getPort() {
        return this.m_Port;
    }

    public String portTipText() {
        return "The port to connect to.";
    }

    public void setUser(String value) {
        this.m_User = value;
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The SSH user to use for connecting.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the SSH user to use for connecting.";
    }

    public void setKnownHosts(PlaceholderFile value) {
        this.m_KnownHosts = value;
    }

    public PlaceholderFile getKnownHosts() {
        return this.m_KnownHosts;
    }

    public String knownHostsTipText() {
        return "The file storing the known hosts.";
    }

    public void setForwardX(boolean value) {
        this.m_ForwardX = value;
        this.reset();
    }

    public boolean getForwardX() {
        return this.m_ForwardX;
    }

    public String forwardXTipText() {
        return "If set to true, then X is forwarded.";
    }

    public void setXHost(String value) {
        this.m_XHost = value;
    }

    public String getXHost() {
        return this.m_XHost;
    }

    public String XHostTipText() {
        return "The xhost (name/IP address) to connect to.";
    }

    public void setXPort(String value) {
        this.m_XPort = value;
        this.reset();
    }

    public String getXPort() {
        return this.m_XPort;
    }

    public String XPortTipText() {
        return "The xport to connect to.";
    }

    public synchronized Session getSession() {
        return this.m_Session;
    }

    protected String doExecute() {
        String result = null;
        try {
            JSch jsch = new JSch();
            jsch.setKnownHosts(this.m_KnownHosts.getAbsolutePath());
            this.m_Session = jsch.getSession(this.m_User, this.m_Host, this.m_Port);
            this.m_Session.setPassword(this.m_Password.getValue());
            if (this.m_ForwardX) {
                this.m_Session.setX11Host(this.m_Host);
                this.m_Session.setX11Port(6000);
            }
            this.m_Session.connect();
        }
        catch (Exception e) {
            String msg = "Failed to connect to '" + this.m_Host + "' as user '" + this.m_User + "': ";
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace((Throwable)e);
            this.m_Session = null;
            result = msg + e;
        }
        return result;
    }

    protected void disconnect() {
        if (this.m_Session != null && this.m_Session.isConnected()) {
            try {
                this.m_Session.disconnect();
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to disconnect from '" + this.m_Host + "':");
                this.getSystemErr().printStackTrace((Throwable)e);
            }
        }
        this.m_Session = null;
    }

    public void wrapUp() {
        this.disconnect();
        super.wrapUp();
    }

    public static int checkAck(InputStream in) throws IOException {
        int result = in.read();
        if (result == 0) {
            return result;
        }
        if (result == -1) {
            return result;
        }
        if (result == 1 || result == 2) {
            int c;
            StringBuilder output = new StringBuilder();
            do {
                c = in.read();
                output.append((char)c);
            } while (c != 10);
            if (result == 1) {
                System.out.print(output.toString());
            }
            if (result == 2) {
                System.out.print(output.toString());
            }
        }
        return result;
    }
}

