/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Utils;
import adams.core.base.BaseText;
import adams.core.option.OptionUtils;
import adams.data.jai.BufferedImageContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.util.Arrays;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;
import org.im4java.core.Stream2BufferedImage;
import org.im4java.process.OutputConsumer;

public class ImageMagickTransformer
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 3690378527551302472L;
    public static final String COMMENT = "#";
    protected BaseText m_Commands;

    public String globalInfo() {
        return "Converts an image using ImageMagick.\nIn order to make entering of commands easier, they can be spread over multiple lines and line comments can be inserted as well (a line comment starts with '#').\n\nNB: Uses im4java, i.e., ImageMagick (http://www.imagemagick.org/) executables must be available on the PATH.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("commands", "commands", (Object)new BaseText());
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("commands");
        if (variable != null) {
            return variable;
        }
        return Utils.shorten((String)this.m_Commands.stringValue(), (int)100);
    }

    public void setCommands(BaseText value) {
        this.m_Commands = value;
        this.reset();
    }

    public BaseText getCommands() {
        return this.m_Commands;
    }

    public String commandsTipText() {
        return "The ImageMagick commands to execute.";
    }

    public Class[] accepts() {
        return new Class[]{BufferedImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{BufferedImageContainer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            BufferedImageContainer img = (BufferedImageContainer)((Object)this.m_InputToken.getPayload());
            IMOperation op = new IMOperation();
            op.addImage();
            if (!this.m_Commands.isEmpty()) {
                String[] lines = this.m_Commands.getValue().split("\n");
                StringBuilder cmds = new StringBuilder();
                for (String line : lines) {
                    if ((line = line.trim()).length() == 0 || line.startsWith(COMMENT)) continue;
                    if (cmds.length() > 0) {
                        cmds.append(" ");
                    }
                    cmds.append(line);
                }
                op.addRawArgs(Arrays.asList(OptionUtils.splitOptions((String)cmds.toString())));
            }
            op.addImage(new String[]{"-"});
            Stream2BufferedImage s2b = new Stream2BufferedImage();
            ConvertCmd cmd = new ConvertCmd();
            cmd.setOutputConsumer((OutputConsumer)s2b);
            cmd.run((Operation)op, new Object[]{img.getImage()});
            BufferedImageContainer cont = (BufferedImageContainer)img.getHeader();
            cont.setImage(s2b.getImage());
            this.m_OutputToken = new Token((Object)cont);
        }
        catch (Exception e) {
            result = e.toString();
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.setProvenance(this.m_InputToken.getProvenance());
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }
}

