/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.Properties;
import adams.core.management.OS;
import adams.env.Environment;
import java.util.Arrays;
import java.util.Vector;

public class Wine {
    public static final String FILENAME = "Wine.props";
    protected static Properties m_Properties;

    public static String[] processCommandLine(String[] cmdline, boolean consoleApp) {
        if (OS.isWindows()) {
            return cmdline;
        }
        Vector<String> result = new Vector<String>(Arrays.asList(cmdline));
        String executable = consoleApp ? Wine.getProperties().getProperty("ConsoleExecutable", "/usr/bin/wineconsole") : Wine.getProperties().getProperty("GUIExecutable", "/usr/bin/wine");
        String parameters = consoleApp ? Wine.getProperties().getProperty("ConsoleParameters", "") : Wine.getProperties().getProperty("GUIParameters", "");
        result.add(0, executable);
        result.add(1, parameters);
        return result.toArray(new String[result.size()]);
    }

    public static String processCommandLine(String cmdline, boolean consoleApp) {
        if (OS.isWindows()) {
            return cmdline;
        }
        String executable = consoleApp ? Wine.getProperties().getProperty("ConsoleExecutable", "/usr/bin/wineconsole") : Wine.getProperties().getProperty("GUIExecutable", "/usr/bin/wine");
        String parameters = consoleApp ? Wine.getProperties().getProperty("ConsoleParameters", "") : Wine.getProperties().getProperty("GUIParameters", "");
        return executable + " " + parameters + " " + cmdline;
    }

    protected static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Environment.getInstance().read("wine");
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }
}

