/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.AbstractDirector;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import java.util.Stack;
import java.util.Vector;

public class SequentialDirector
extends AbstractDirector {
    private static final long serialVersionUID = -1634725837304059804L;
    protected transient Vector<Token> m_FinalOutput;
    protected boolean m_Finished;
    protected boolean m_Executed;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FinalOutput = null;
    }

    protected boolean isFinalOutputRecorded() {
        return false;
    }

    protected Vector<Token> getFinalOutput() {
        if (this.m_FinalOutput == null) {
            this.m_FinalOutput = new Vector();
        }
        return this.m_FinalOutput;
    }

    protected String checkActorHasStopped(AbstractActor actor) {
        String result = null;
        if (actor.isStopped()) {
            Throwable th = new Throwable();
            th.fillInStackTrace();
            result = th.getStackTrace()[1].getMethodName() + ": Actor '" + actor.getFullName() + "' is stopped!";
        }
        return result;
    }

    protected String doInput(AbstractActor actor, Token input) {
        String result = null;
        String msg = this.checkActorHasStopped(actor);
        if (msg != null) {
            return msg;
        }
        try {
            ((InputConsumer)((Object)actor)).input(input);
        }
        catch (Exception e) {
            msg = "Actor '" + actor.getFullName() + "' generated the following " + "exception on calling the 'input(Token)' method with token '" + input + "': ";
            result = msg + e;
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
        }
        if (result != null) {
            actor.handleError("input", result);
        }
        return result;
    }

    protected String doExecute(AbstractActor actor) {
        String result;
        String msg = this.checkActorHasStopped(actor);
        if (msg != null) {
            return msg;
        }
        try {
            if (this.getDebugLevel() >= 10) {
                this.debug("Size before 'execute()': " + actor.sizeOf() + " [" + actor.getFullName() + "]", 10);
            }
            result = actor.execute();
            if (this.getDebugLevel() >= 10) {
                this.debug("Size after 'execute()': " + actor.sizeOf() + " [" + actor.getFullName() + "]", 10);
            }
        }
        catch (Exception e) {
            msg = "Actor '" + actor.getFullName() + "' generated the following " + "exception on calling the 'execute()' method: ";
            result = msg + e;
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
        }
        if (result != null) {
            actor.handleError("execute", result);
        }
        return result;
    }

    protected boolean doHasOutput(AbstractActor actor) {
        boolean result;
        if (this.checkActorHasStopped(actor) != null) {
            return false;
        }
        String msgFull = null;
        try {
            result = ((OutputProducer)((Object)actor)).hasPendingOutput();
        }
        catch (Exception e) {
            result = false;
            String msg = "Actor '" + actor.getFullName() + "' generated the following " + "exception on calling the 'hasPendingOutput()' method: ";
            msgFull = msg + e;
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
        }
        if (msgFull != null) {
            actor.handleError("hasPendingOutput", msgFull);
        }
        return result;
    }

    protected Token doOutput(AbstractActor actor) {
        Token result;
        if (this.checkActorHasStopped(actor) != null) {
            return null;
        }
        String msgFull = null;
        try {
            if (this.getDebugLevel() >= 10) {
                this.debug("Size before 'output()': " + actor.sizeOf() + " [" + actor.getFullName() + "]", 10);
            }
            result = ((OutputProducer)((Object)actor)).output();
            if (this.getDebugLevel() >= 10) {
                this.debug("Size after 'output()': " + actor.sizeOf() + " [" + actor.getFullName() + "]", 10);
            }
        }
        catch (Exception e) {
            result = null;
            String msg = "Actor '" + actor.getFullName() + "' generated the following " + "exception on calling the 'output()' method: ";
            msgFull = msg + e;
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
        }
        if (msgFull != null) {
            actor.handleError("output", msgFull);
        }
        return result;
    }

    protected AbstractActor doExecuteStandalones() {
        AbstractActor result = null;
        for (int i = 0; i < this.m_ControlActor.size(); ++i) {
            if (this.m_Paused) {
                this.pause();
            }
            if (this.isStopped() || this.isStopping()) break;
            AbstractActor curr = this.m_ControlActor.get(i);
            if (curr.getSkip()) continue;
            if (!ActorUtils.isStandalone(curr)) {
                result = curr;
                break;
            }
            String actorResult = this.doExecute(curr);
            if (actorResult == null) continue;
            this.getSystemErr().println(curr.getFullName() + " generated following error output:\n" + actorResult);
        }
        return result;
    }

    protected String doExecuteActors(AbstractActor startActor) {
        boolean finished;
        String result = null;
        AbstractActor notFinishedActor = startActor;
        Stack<AbstractActor> pendingActors = new Stack<AbstractActor>();
        this.getFinalOutput().clear();
        do {
            int startIndex;
            if (this.isDebugOn()) {
                this.debug("--> iteration start");
            }
            if (this.isPaused()) {
                this.pause();
            }
            if (this.isStopped() || this.isStopping()) break;
            if (pendingActors.size() > 0) {
                startIndex = this.m_ControlActor.indexOf(((AbstractActor)pendingActors.peek()).getName());
            } else {
                startIndex = this.m_ControlActor.indexOf(notFinishedActor.getName());
                notFinishedActor = null;
            }
            if (this.isDebugOn()) {
                this.debug("Start index: " + startIndex, 2);
            }
            AbstractActor curr = null;
            Token token = null;
            int lastActive = -1;
            if (this.m_ControlActor.active() > 0) {
                lastActive = this.m_ControlActor.lastActive().index();
            }
            for (int i = startIndex; i <= lastActive; ++i) {
                String actorResult;
                if (this.isPaused()) {
                    this.pause();
                }
                if (this.isStopped() || this.isStopping()) break;
                curr = this.m_ControlActor.get(i);
                if (curr.getSkip()) continue;
                if (this.isDebugOn()) {
                    this.debug("Current actor: " + curr.getFullName(), 2);
                }
                if (token == null) {
                    if (curr instanceof OutputProducer && this.doHasOutput(curr)) {
                        pendingActors.pop();
                        this.debug("Actor holds another output token: " + curr.getFullName(), 2);
                    } else {
                        actorResult = this.doExecute(curr);
                        if (actorResult != null) {
                            this.getSystemErr().println(curr.getFullName() + " generated following error output:\n" + actorResult);
                            if (curr.getStopFlowOnError()) break;
                        }
                        if (!curr.isFinished() && notFinishedActor == null) {
                            notFinishedActor = curr;
                        }
                        if (this.isDebugOn()) {
                            this.debug("Actor needed to be executed: " + curr.getFullName(), 2);
                        }
                    }
                    token = curr instanceof OutputProducer && this.doHasOutput(curr) ? this.doOutput(curr) : null;
                    if (this.getDebugLevel() > 2) {
                        this.debug("Token obtained from output: " + token, 3);
                    } else {
                        this.debug("Token obtained from output", 2);
                    }
                    if (curr instanceof OutputProducer && this.doHasOutput(curr)) {
                        pendingActors.push(curr);
                        if (this.isDebugOn()) {
                            this.debug("Actor has more tokens on output: " + curr.getFullName(), 2);
                        }
                    }
                } else {
                    this.doInput(curr, token);
                    actorResult = this.doExecute(curr);
                    if (actorResult != null) {
                        this.getSystemErr().println(curr.getFullName() + " generated following error output:\n" + actorResult);
                        if (curr.getStopFlowOnError()) break;
                    }
                    if (!curr.isFinished() && notFinishedActor == null) {
                        notFinishedActor = curr;
                    }
                    if (this.getDebugLevel() > 2) {
                        this.debug("Actor processes token: " + curr.getFullName() + "/" + token, 3);
                    } else {
                        this.debug("Actor processes token: " + curr.getFullName(), 2);
                    }
                    if (curr instanceof OutputProducer) {
                        token = this.doHasOutput(curr) ? this.doOutput(curr) : null;
                        if (this.isDebugOn()) {
                            this.debug("Actor also produces tokens: " + curr.getFullName(), 2);
                        }
                        if (this.doHasOutput(curr)) {
                            if (this.isDebugOn()) {
                                this.debug("Actor also has more tokens on output: " + curr.getFullName(), 2);
                            }
                            pendingActors.push(curr);
                        }
                    } else {
                        token = null;
                    }
                }
                if (i == this.m_ControlActor.lastActive().index() && token != null && this.isFinalOutputRecorded()) {
                    this.getFinalOutput().add(token);
                }
                if (!(curr instanceof OutputProducer) || token != null) continue;
                if (!this.isDebugOn()) break;
                this.debug("No token generated, skipping rest of actors: " + curr.getFullName(), 2);
                break;
            }
            if (this.isDebugOn()) {
                this.debug("notFinishedActor=" + notFinishedActor + ", pendingActors.size=" + pendingActors.size() + ", stopped=" + this.isStopped(), 2);
            }
            boolean bl = finished = notFinishedActor == null && pendingActors.size() == 0;
            if (!this.isDebugOn()) continue;
            this.debug("---> execution finished: " + finished);
        } while (!finished || this.isStopped() || this.isStopping());
        return result;
    }

    @Override
    public String execute() {
        String msg;
        String result = null;
        AbstractActor start = null;
        this.m_Finished = false;
        this.m_Executed = true;
        if (this.m_ControlActor.getActorHandlerInfo().canContainStandalones()) {
            try {
                start = this.doExecuteStandalones();
                if (this.isDebugOn()) {
                    this.debug("doExecuteStandalones: " + (start == null ? "only standalones" : start.getFullName()));
                }
            }
            catch (Exception e) {
                this.getSystemErr().printStackTrace(e);
                msg = e.toString();
                if (this.isDebugOn()) {
                    this.debug("doExecuteStandalones: " + msg);
                }
                result = "Execution of standalones failed: " + msg;
            }
        } else if (this.m_ControlActor.size() > 0) {
            start = this.m_ControlActor.get(0);
        }
        if (result == null && !this.isStopped() && !this.isStopping() && start != null) {
            if (this.isDebugOn()) {
                this.debug("doExecuteActors: start");
            }
            try {
                msg = this.doExecuteActors(start);
                if (this.isDebugOn()) {
                    this.debug("doExecuteActors: " + (msg == null ? "OK" : msg));
                }
                if (msg != null) {
                    result = "Execution of actors failed: " + msg;
                }
            }
            catch (Exception e) {
                this.getSystemErr().printStackTrace(e);
                msg = e.toString();
                if (this.isDebugOn()) {
                    this.debug("doExecuteActors: " + msg);
                }
                result = "Execution of actors died: " + msg;
            }
            if (this.isDebugOn()) {
                this.debug("doExecuteActors: end");
            }
        }
        this.getFinalOutput().clear();
        this.m_Finished = true;
        return result;
    }

    @Override
    public boolean isFinished() {
        return this.m_Executed && this.m_Finished || !this.m_Executed || this.m_Stopped;
    }

    @Override
    public void stopExecution() {
        super.stopExecution();
        this.getFinalOutput().clear();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_FinalOutput != null) {
            this.m_FinalOutput.clear();
        }
    }
}

