/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.AbstractTee;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;

public class Trigger
extends AbstractTee {
    private static final long serialVersionUID = 4690934665757923783L;

    @Override
    public String globalInfo() {
        return "Executes the tee-actor whenever a token gets passed through. In contrast to the Tee actor, it doesn't feed the tee-actor with the current token.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Actors.setAllowStandalones(true);
        this.m_Actors.setAllowSource(true);
    }

    @Override
    protected String setUpTeeActors() {
        return ActorUtils.checkForSource(this.getActors());
    }

    public boolean canContainStandalones() {
        return true;
    }

    @Override
    protected String checkTeeActor(int index, AbstractActor actor) {
        return null;
    }

    @Override
    protected String checkTeeActors(AbstractActor[] actors) {
        return ActorUtils.checkForSource(actors);
    }

    @Override
    protected String processInput(Token token) {
        String result;
        try {
            result = this.m_Actors.execute();
        }
        catch (Exception e) {
            String msg = "Failed to trigger: ";
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace(e);
            result = msg + e;
        }
        return result;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, ActorExecution.SEQUENTIAL, false);
    }
}

