/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.ConsoleObject;
import adams.core.Properties;
import adams.core.io.FileUtils;
import adams.env.Environment;
import adams.gui.event.RecentFileEvent;
import adams.gui.event.RecentFileListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class RecentFilesHandler
extends ConsoleObject {
    private static final long serialVersionUID = 7532226757387619342L;
    public static final String RECENTFILES_COUNT = "RecentFilesCount";
    public static final String RECENTFILES_PREFIX = "RecentFile.";
    protected String m_PropertiesFile;
    protected String m_PropertyPrefix;
    protected int m_MaxCount;
    protected JMenu m_Menu;
    protected Vector<File> m_RecentFiles;
    protected boolean m_IgnoreChanges;
    protected HashSet<RecentFileListener> m_Listeners;

    public RecentFilesHandler(String propsFile, JMenu menu) {
        this(propsFile, 5, menu);
    }

    public RecentFilesHandler(String propsFile, int maxCount, JMenu menu) {
        this(propsFile, null, maxCount, menu);
    }

    public RecentFilesHandler(String propsFile, String propPrefix, int maxCount, JMenu menu) {
        this.m_PropertiesFile = Environment.getInstance().getHome() + File.separator + new File(propsFile).getName();
        this.m_PropertyPrefix = propPrefix;
        this.m_MaxCount = maxCount;
        this.m_Menu = menu;
        this.m_RecentFiles = new Vector();
        this.m_IgnoreChanges = false;
        this.m_Listeners = new HashSet();
        this.readProps();
        this.updateMenu();
    }

    public String getPropertiesFile() {
        return this.m_PropertiesFile;
    }

    public String getPropertyPrefix() {
        return this.m_PropertyPrefix;
    }

    public int getMaxCount() {
        return this.m_MaxCount;
    }

    public JMenu getMenu() {
        return this.m_Menu;
    }

    protected String expand(String property) {
        if (this.m_PropertyPrefix == null) {
            return property;
        }
        return this.m_PropertyPrefix + property;
    }

    protected Properties loadProps() {
        Properties result;
        try {
            result = new Properties();
            File file = new File(this.m_PropertiesFile);
            if (file.exists()) {
                result.load(this.m_PropertiesFile);
            }
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = new Properties();
        }
        return result;
    }

    protected void readProps() {
        this.m_IgnoreChanges = true;
        Properties props = this.loadProps();
        int count = props.getInteger(this.expand(RECENTFILES_COUNT), 0);
        this.m_RecentFiles.clear();
        for (int i = count - 1; i >= 0; --i) {
            File file;
            String filename = props.getString(this.expand(RECENTFILES_PREFIX + i), "");
            if (filename.length() <= 0 || !(file = new File(filename)).exists()) continue;
            this.addRecentFile(file);
        }
        this.m_IgnoreChanges = false;
    }

    protected synchronized void writeProps() {
        Properties props = this.loadProps();
        props.setInteger(this.expand(RECENTFILES_COUNT), this.m_RecentFiles.size());
        for (int i = 0; i < this.m_RecentFiles.size(); ++i) {
            props.setString(this.expand(RECENTFILES_PREFIX + i), this.m_RecentFiles.get(i).getAbsolutePath());
        }
        try {
            props.save(this.m_PropertiesFile);
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
        }
    }

    protected synchronized int determineMinimumNumberOfParentDirs() {
        HashSet<String> files;
        int result = -1;
        int num = 0;
        do {
            files = new HashSet<String>();
            for (int i = 0; i < this.m_RecentFiles.size(); ++i) {
                files.add(FileUtils.createPartialFilename(this.m_RecentFiles.get(i), num));
            }
            if (files.size() == this.m_RecentFiles.size()) {
                result = num;
                continue;
            }
            ++num;
        } while (files.size() < this.m_RecentFiles.size());
        return result;
    }

    protected synchronized void updateMenu() {
        int num = this.determineMinimumNumberOfParentDirs();
        this.m_Menu.removeAll();
        this.m_Menu.setEnabled(this.m_RecentFiles.size() > 0);
        for (int i = 0; i < this.m_RecentFiles.size(); ++i) {
            final File file = this.m_RecentFiles.get(i);
            JMenuItem item = new JMenuItem(i + 1 + " - " + FileUtils.createPartialFilename(file, num));
            if (i < 9) {
                item.setMnemonic(Integer.toString(i + 1).charAt(0));
            }
            if (i == 10) {
                item.setMnemonic('0');
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RecentFilesHandler.this.notifyRecentFileListenersOfSelect(file);
                }
            });
            this.m_Menu.add(item);
        }
    }

    public synchronized void addRecentFile(File file) {
        file = new File(file.getAbsolutePath());
        if (this.m_RecentFiles.size() > 0 && file.equals(this.m_RecentFiles.get(0))) {
            return;
        }
        this.m_RecentFiles.remove(file);
        this.m_RecentFiles.add(0, file);
        while (this.m_RecentFiles.size() > this.m_MaxCount) {
            this.m_RecentFiles.remove(this.m_RecentFiles.size() - 1);
        }
        if (this.m_IgnoreChanges) {
            return;
        }
        this.writeProps();
        this.updateMenu();
        this.notifyRecentFileListenersOfAdd(file);
    }

    public synchronized void removeRecentFile(File file) {
        file = new File(file.getAbsolutePath());
        this.m_RecentFiles.remove(file);
        if (this.m_IgnoreChanges) {
            return;
        }
        this.writeProps();
        this.updateMenu();
    }

    public Vector<File> getRecentFiles() {
        return new Vector<File>(this.m_RecentFiles);
    }

    public int size() {
        return this.m_RecentFiles.size();
    }

    public void addRecentFileListener(RecentFileListener l) {
        this.m_Listeners.add(l);
    }

    public void removeRecentFileListener(RecentFileListener l) {
        this.m_Listeners.remove(l);
    }

    protected void notifyRecentFileListenersOfAdd(File file) {
        RecentFileEvent e = new RecentFileEvent(this, file);
        Iterator<RecentFileListener> iter = this.m_Listeners.iterator();
        while (iter.hasNext()) {
            iter.next().recentFileAdded(e);
        }
    }

    protected void notifyRecentFileListenersOfSelect(File file) {
        RecentFileEvent e = new RecentFileEvent(this, file);
        Iterator<RecentFileListener> iter = this.m_Listeners.iterator();
        while (iter.hasNext()) {
            iter.next().recentFileSelected(e);
        }
    }
}

