/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import adams.gui.goe.PropertyPanel;
import adams.gui.goe.PropertySheetPanel;
import adams.gui.goe.VariableSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InlineEditor
extends BasePanel
implements PropertyEditor,
CustomStringRepresentationHandler,
PropertyPanel.PopupMenuCustomizer,
PropertyChangeListener,
MultiSelectionEditor {
    private static final long serialVersionUID = 2445831775173113711L;
    protected JTextField m_TextField;
    protected JButton m_ButtonEditor;
    protected PropertySheetPanel m_PropertySheetPanel;
    protected PropertyEditor m_Editor;
    protected Color m_DefaultBackground;
    protected HashSet<PropertyChangeListener> m_PropertyChangeListeners;
    protected boolean m_UpdateTextAfterDisplay;

    public InlineEditor(PropertyEditor pe) {
        this(pe, null);
    }

    public InlineEditor(PropertyEditor pe, PropertySheetPanel panel) {
        if (pe == null) {
            throw new IllegalArgumentException("Editor is null!");
        }
        if (!(pe instanceof InlineEditorSupport)) {
            throw new IllegalArgumentException("Editor '" + pe.getClass().getName() + "' does not implement '" + InlineEditorSupport.class.getName() + "'!");
        }
        this.m_Editor = pe;
        this.m_PropertySheetPanel = panel;
        this.updateText(this.getInlineEditor().getInlineValue());
        if (!this.m_Editor.supportsCustomEditor() || this.m_Editor.getCustomEditor() == null) {
            this.m_ButtonEditor.setVisible(false);
            this.remove(this.m_ButtonEditor);
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PropertyChangeListeners = new HashSet();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_DefaultBackground = this.getBackground();
        this.setBorder(BorderFactory.createLineBorder(this.m_DefaultBackground));
        this.m_TextField = new JTextField(20);
        this.m_TextField.setText("");
        this.m_TextField.setPreferredSize(new Dimension(this.m_TextField.getPreferredSize().width, this.m_TextField.getPreferredSize().height + 4));
        this.m_TextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                InlineEditor.this.updateText(InlineEditor.this.m_TextField.getText());
                super.focusLost(e);
            }
        });
        this.m_TextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                InlineEditor.this.indicateValidity();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InlineEditor.this.indicateValidity();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                InlineEditor.this.indicateValidity();
            }
        });
        this.m_TextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    e.consume();
                    JPopupMenu menu = new JPopupMenu();
                    InlineEditor.this.customizePopup(InlineEditor.this, menu);
                    if (InlineEditor.this.m_PropertySheetPanel != null) {
                        VariableSupport.updatePopup(InlineEditor.this.m_PropertySheetPanel, InlineEditor.this, menu);
                    }
                    menu.show(InlineEditor.this.m_TextField, e.getX(), e.getY());
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.add((Component)this.m_TextField, "Center");
        this.m_ButtonEditor = new JButton("...");
        this.m_ButtonEditor.setPreferredSize(new Dimension(this.m_ButtonEditor.getPreferredSize().width, this.m_TextField.getPreferredSize().height));
        this.m_ButtonEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InlineEditor.this.showEditor();
            }
        });
        this.add((Component)this.m_ButtonEditor, "East");
        this.updatePreferredSize();
    }

    public PropertyEditor getEditor() {
        return this.m_Editor;
    }

    public InlineEditorSupport getInlineEditor() {
        return (InlineEditorSupport)((Object)this.m_Editor);
    }

    protected void showEditor() {
        this.m_UpdateTextAfterDisplay = false;
        BaseDialog dlg = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new BaseDialog(this.getParentFrame(), true);
        dlg.getContentPane().add(this.m_Editor.getCustomEditor(), "Center");
        dlg.pack();
        dlg.setLocationRelativeTo(this);
        this.m_Editor.addPropertyChangeListener(this);
        dlg.setVisible(true);
        this.m_Editor.removePropertyChangeListener(this);
        if (this.m_UpdateTextAfterDisplay) {
            this.setValue(this.m_Editor.getValue());
        }
        this.m_UpdateTextAfterDisplay = false;
    }

    protected boolean isValid(String s) {
        return this.getInlineEditor().isInlineValueValid(s);
    }

    protected boolean updateText(String s) {
        if (this.isValid(s)) {
            this.m_TextField.setText(s);
            this.getInlineEditor().setInlineValue(s);
            this.notifyPropertyChangeListeners();
            return true;
        }
        this.m_TextField.setText(this.getInlineEditor().getInlineValue());
        return false;
    }

    protected void indicateValidity() {
        Color curColor = ((LineBorder)this.getBorder()).getLineColor();
        Color newColor = this.isValid(this.m_TextField.getText()) ? this.m_DefaultBackground : Color.RED;
        if (!newColor.equals(curColor)) {
            this.setBorder(BorderFactory.createLineBorder(newColor));
        }
    }

    public void setTextColumns(int value) {
        if (value > 0) {
            this.m_TextField.setColumns(value);
        } else {
            System.err.println("Number of columns must be >0 (provided: " + value + ")!");
        }
        this.updatePreferredSize();
    }

    public int getTextColumns() {
        return this.m_TextField.getColumns();
    }

    protected void updatePreferredSize() {
        this.setPreferredSize(new Dimension(this.m_TextField.getPreferredSize().width + this.m_ButtonEditor.getPreferredSize().width, this.m_TextField.getPreferredSize().height));
    }

    public void update() {
        this.updateText(this.getInlineEditor().getInlineValue());
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        if (this.m_Editor instanceof CustomStringRepresentationHandler) {
            return ((CustomStringRepresentationHandler)((Object)this.m_Editor)).toCustomStringRepresentation(obj);
        }
        try {
            this.m_Editor.setValue(obj);
            return this.getInlineEditor().getInlineValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to obtain custom string representation", e);
        }
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        if (this.m_Editor instanceof CustomStringRepresentationHandler) {
            return ((CustomStringRepresentationHandler)((Object)this.m_Editor)).fromCustomStringRepresentation(str);
        }
        try {
            this.getInlineEditor().setInlineValue(str);
            return this.m_Editor.getValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set custom string representation", e);
        }
    }

    @Override
    public void customizePopup(BasePanel owner, JPopupMenu menu) {
        JMenuItem menuitem = new JMenuItem("Copy");
        menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(this.isValid(this.m_TextField.getText()));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InlineEditor.this.m_TextField.getSelectedText() != null) {
                    GUIHelper.copyToClipboard(InlineEditor.this.m_TextField.getSelectedText());
                } else {
                    GUIHelper.copyToClipboard(InlineEditor.this.m_TextField.getText());
                }
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Paste");
        menuitem.setIcon(GUIHelper.getIcon("paste.gif"));
        menuitem.setEnabled(GUIHelper.canPasteFromClipboard());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InlineEditor.this.m_TextField.replaceSelection(GUIHelper.pasteFromClipboard());
            }
        });
        menu.add(menuitem);
        if (this.m_Editor instanceof PropertyPanel.PopupMenuCustomizer) {
            ((PropertyPanel.PopupMenuCustomizer)((Object)this.m_Editor)).customizePopup(owner, menu);
        }
    }

    @Override
    public void setValue(Object value) {
        this.updateText(this.toCustomStringRepresentation(value));
    }

    @Override
    public Object getValue() {
        return this.fromCustomStringRepresentation(this.m_TextField.getText());
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return "";
    }

    @Override
    public String getAsText() {
        return this.m_TextField.getText();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.m_TextField.setText(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.m_PropertyChangeListeners.add(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.m_PropertyChangeListeners.remove(listener);
    }

    protected void notifyPropertyChangeListeners() {
        PropertyChangeEvent e = new PropertyChangeEvent(this, "", null, null);
        for (PropertyChangeListener l : this.m_PropertyChangeListeners) {
            l.propertyChange(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.m_UpdateTextAfterDisplay = true;
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] result;
        Component comp = this.getCustomEditor();
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the string representations, one per line:");
        dialog.setLocationRelativeTo(comp.getParent());
        dialog.setVisible(true);
        Object backup = this.getEditor().getValue();
        Class<?> cls = backup.getClass();
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = (Object[])Array.newInstance(cls, lines.size());
            for (int i = 0; i < lines.size(); ++i) {
                Array.set(result, i, this.fromCustomStringRepresentation(lines.get(i)));
            }
            this.getEditor().setValue(backup);
        } else {
            result = (Object[])Array.newInstance(cls, 0);
        }
        return result;
    }
}

