/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import javax.swing.JFileChooser;
import weka.gui.PropertyDialog;

public class FileEditor
extends PropertyEditorSupport {
    protected JFileChooser m_FileChooser;

    @Override
    public String getJavaInitializationString() {
        File f = (File)this.getValue();
        if (f == null) {
            return "null";
        }
        return "new File(\"" + f.getName() + "\")";
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.m_FileChooser == null) {
            File currentFile = (File)this.getValue();
            if (currentFile != null) {
                this.m_FileChooser = new JFileChooser();
                this.m_FileChooser.setSelectedFile(currentFile);
            } else {
                this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
            }
            this.m_FileChooser.setApproveButtonText("Select");
            this.m_FileChooser.setApproveButtonMnemonic('S');
            this.m_FileChooser.setFileSelectionMode(2);
            this.m_FileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String cmdString = e.getActionCommand();
                    if (cmdString.equals("ApproveSelection")) {
                        File newVal = FileEditor.this.m_FileChooser.getSelectedFile();
                        FileEditor.this.setValue(newVal);
                    }
                    FileEditor.this.closeDialog();
                }
            });
        }
        return this.m_FileChooser;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        File f = (File)this.getValue();
        String val = "No file";
        if (f != null) {
            val = f.getName();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected void closeDialog() {
        Dialog dlg;
        if (this.m_FileChooser instanceof Container && (dlg = PropertyDialog.getParentDialog(this.m_FileChooser)) != null) {
            dlg.setVisible(false);
        }
    }
}

