/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jdatepicker.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.jdatepicker.DateModel;
import net.sourceforge.jdatepicker.JDatePanel;
import net.sourceforge.jdatepicker.JDatePicker;
import net.sourceforge.jdatepicker.impl.DateComponentFormatter;
import net.sourceforge.jdatepicker.impl.JDatePanelImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDatePickerImpl
extends JPanel
implements JDatePicker {
    private static final long serialVersionUID = 2814777654384974503L;
    private Popup popup;
    private JFormattedTextField formattedTextField;
    private JButton button;
    private JDatePanelImpl datePanel;
    private InternalEventHandler internalEventHandler;

    public JDatePickerImpl(JDatePanelImpl dateInstantPanel) {
        this(dateInstantPanel, null);
    }

    public JDatePickerImpl(JDatePanelImpl datePanel, JFormattedTextField.AbstractFormatter formatter) {
        this.datePanel = datePanel;
        this.popup = null;
        datePanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.internalEventHandler = new InternalEventHandler();
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.formattedTextField = new JFormattedTextField(formatter != null ? formatter : this.createDefaultFormatter());
        DateModel<?> model = datePanel.getModel();
        this.setTextFieldValue(this.formattedTextField, model.getYear(), model.getMonth(), model.getDay(), model.isSelected());
        this.formattedTextField.setEditable(false);
        this.add(this.formattedTextField);
        layout.putConstraint("West", (Component)this.formattedTextField, 0, "West", (Component)this);
        layout.putConstraint("South", (Component)this, 0, "South", (Component)this.formattedTextField);
        this.button = new JButton("...");
        this.button.setFocusable(true);
        this.add(this.button);
        layout.putConstraint("West", (Component)this.button, 1, "East", (Component)this.formattedTextField);
        layout.putConstraint("East", (Component)this, 0, "East", (Component)this.button);
        layout.putConstraint("South", (Component)this, 0, "South", (Component)this.button);
        int h = (int)this.button.getPreferredSize().getHeight();
        int w = (int)datePanel.getPreferredSize().getWidth();
        this.button.setPreferredSize(new Dimension(h, h));
        this.formattedTextField.setPreferredSize(new Dimension(w - h - 1, h));
        this.addHierarchyBoundsListener(this.internalEventHandler);
        this.button.addActionListener(this.internalEventHandler);
        this.formattedTextField.addPropertyChangeListener("value", this.internalEventHandler);
        datePanel.addActionListener(this.internalEventHandler);
        datePanel.getModel().addChangeListener(this.internalEventHandler);
    }

    protected JFormattedTextField.AbstractFormatter createDefaultFormatter() {
        return new DateComponentFormatter();
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.datePanel.addActionListener(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.datePanel.removeActionListener(actionListener);
    }

    @Override
    public void setI18nStrings(Properties i18nStrings) {
        this.datePanel.setI18nStrings(i18nStrings);
    }

    @Override
    public Properties getI18nStrings() {
        return this.datePanel.getI18nStrings();
    }

    @Override
    public DateModel<?> getModel() {
        return this.datePanel.getModel();
    }

    @Override
    public void setTextEditable(boolean editable) {
        this.formattedTextField.setEditable(editable);
    }

    @Override
    public boolean isTextEditable() {
        return this.formattedTextField.isEditable();
    }

    @Override
    public void setButtonFocusable(boolean focusable) {
        this.button.setFocusable(focusable);
    }

    @Override
    public boolean getButtonFocusable() {
        return this.button.isFocusable();
    }

    public JDatePanel getJDateInstantPanel() {
        return this.datePanel;
    }

    public JFormattedTextField getJFormattedTextField() {
        return this.formattedTextField;
    }

    private void showPopup() {
        if (this.popup == null) {
            PopupFactory fac = new PopupFactory();
            Point xy = this.getLocationOnScreen();
            this.datePanel.setVisible(true);
            this.popup = fac.getPopup(this, this.datePanel, (int)xy.getX(), (int)(xy.getY() + (double)this.getHeight()));
            this.popup.show();
        }
    }

    private void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public boolean isDoubleClickAction() {
        return this.datePanel.isDoubleClickAction();
    }

    @Override
    public boolean isShowYearButtons() {
        return this.datePanel.isShowYearButtons();
    }

    @Override
    public void setDoubleClickAction(boolean doubleClickAction) {
        this.datePanel.setDoubleClickAction(doubleClickAction);
    }

    @Override
    public void setShowYearButtons(boolean showYearButtons) {
        this.datePanel.setShowYearButtons(showYearButtons);
    }

    private void setTextFieldValue(JFormattedTextField textField, int year, int month, int day, boolean isSelected) {
        if (!isSelected) {
            textField.setValue(null);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month, day, 0, 0, 0);
            calendar.set(14, 0);
            textField.setValue(calendar);
        }
    }

    private class InternalEventHandler
    implements ActionListener,
    HierarchyBoundsListener,
    ChangeListener,
    PropertyChangeListener {
        private InternalEventHandler() {
        }

        public void ancestorMoved(HierarchyEvent arg0) {
            JDatePickerImpl.this.hidePopup();
        }

        public void ancestorResized(HierarchyEvent arg0) {
            JDatePickerImpl.this.hidePopup();
        }

        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource() == JDatePickerImpl.this.button) {
                if (JDatePickerImpl.this.popup == null) {
                    JDatePickerImpl.this.showPopup();
                } else {
                    JDatePickerImpl.this.hidePopup();
                }
            } else if (arg0.getSource() == JDatePickerImpl.this.datePanel) {
                JDatePickerImpl.this.hidePopup();
            }
        }

        public void stateChanged(ChangeEvent arg0) {
            if (arg0.getSource() == JDatePickerImpl.this.datePanel.getModel()) {
                DateModel<?> model = JDatePickerImpl.this.datePanel.getModel();
                JDatePickerImpl.this.setTextFieldValue(JDatePickerImpl.this.formattedTextField, model.getYear(), model.getMonth(), model.getDay(), model.isSelected());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (JDatePickerImpl.this.formattedTextField.isEditable() && JDatePickerImpl.this.formattedTextField.getValue() != null) {
                Calendar value = (Calendar)JDatePickerImpl.this.formattedTextField.getValue();
                JDatePickerImpl.this.datePanel.getModel().setDate(value.get(1), value.get(2), value.get(5));
                JDatePickerImpl.this.datePanel.getModel().setSelected(true);
            }
        }
    }
}

