/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.Image;
import JSci.instruments.ImageSink;
import JSci.instruments.ImageSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class Simulated
implements ImageSource,
Runnable {
    private Dimension dim = new Dimension(600, 500);
    private ImageSink sink;
    public static double z;
    private long num = 0L;
    private double theta = 0.0;
    private double vs;
    private double vc;
    private double dh;
    private final double R = 100.0;
    private static boolean oscillate;

    public Simulated() {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public void setSink(ImageSink imageSink) {
        if (this.sink != imageSink) {
            this.sink = imageSink;
            this.sink.setSource(this);
        }
    }

    public void run() {
        boolean bl = false;
        while (true) {
            Image image = this.getImage();
            if (this.sink != null) {
                this.sink.receive(image);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public int getWidth() {
        return this.dim.width;
    }

    public int getHeight() {
        return this.dim.height;
    }

    public Dimension getSize() {
        return this.dim;
    }

    public Component getControlComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        final JButton jButton = new JButton("Oscillate");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !Simulated.getOscillating();
                Simulated.setOscillating(bl);
                if (bl) {
                    jButton.setText("Stop");
                } else {
                    jButton.setText("Oscillate");
                }
            }
        });
        jPanel.add("North", new JLabel("Test"));
        jPanel.add("South", jButton);
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "source");
        jPanel.setBorder(titledBorder);
        return jPanel;
    }

    private double f(double d) {
        return 1.0 / (1.0 - Math.pow(d, 2.0) + Math.pow(d, 4.0));
    }

    private double g(double d, double d2) {
        return this.f(Math.sqrt(Math.pow(d - this.vc, 2.0) + Math.pow(d2 - this.vs, 2.0)) / (5.0 + (z + this.dh) / 4.0));
    }

    private Image getImage() {
        int n;
        int n2;
        this.vs = 0.0;
        this.theta += 0.04;
        final byte[] byArray = new byte[300000];
        for (n2 = 0; n2 < 300000; ++n2) {
            byArray[n2] = 0;
        }
        this.vc = 100.0 * Math.cos(this.theta);
        this.dh = oscillate ? Math.sin(this.theta * 1.3) : 0.0;
        for (n2 = 170; n2 < 430; ++n2) {
            for (n = 320; n < 380; ++n) {
                byArray[n2 + n * 600] = (byte)(160.0 * this.g((double)n2 - 300.0, (double)n - 350.0));
            }
        }
        double d = 300.0 + this.vc;
        double d2 = 350.0;
        double d3 = this.dh;
        this.theta += 2.0;
        this.vc = 100.0 * Math.cos(this.theta);
        this.theta -= 2.0;
        this.dh = oscillate ? Math.cos(this.theta * 1.3) : 0.0;
        for (n2 = 170; n2 < 430; ++n2) {
            for (n = 120; n < 180; ++n) {
                byArray[n2 + n * 600] = (byte)(100.0 * this.g((double)n2 - 300.0, (double)n - 150.0));
            }
        }
        double d4 = 300.0 + this.vc;
        double d5 = 150.0;
        double d6 = this.dh;
        final long l = System.currentTimeMillis();
        final Dimension dimension = new Dimension(this.getWidth(), this.getHeight());
        Image image = new Image(){

            public byte[] getData() {
                return byArray;
            }

            public Dimension getSize() {
                return dimension;
            }

            public long getTimeStamp() {
                return l;
            }
        };
        System.out.println("#Simulated: " + this.num + " " + d + " " + d2 + " " + d3 + " " + d4 + " " + d5 + " " + d6);
        return image;
    }

    public static void setOscillating(boolean bl) {
        oscillate = bl;
    }

    public static boolean getOscillating() {
        return oscillate;
    }
}

