/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.base.BasePassword;
import adams.flow.standalone.AbstractStandalone;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.http.AccessToken;

public class TwitterConnection
extends AbstractStandalone {
    private static final long serialVersionUID = -1959430342987913960L;
    protected String m_ConsumerKey;
    protected BasePassword m_ConsumerSecret;
    protected String m_AccessToken;
    protected BasePassword m_AccessTokenSecret;

    public String globalInfo() {
        return "Provides access to various twitter services.\nFor your own twitter account, you can obtain consumer key and access token for ADAMS (= application trying to access twitter) here:\n  https://dev.twitter.com/apps/\nAnd make sure that ADAMS has READ and WRITE access.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("consumer-key", "consumerKey", (Object)"");
        this.m_OptionManager.add("consumer-secret", "consumerSecret", (Object)new BasePassword(""));
        this.m_OptionManager.add("access-token", "accessToken", (Object)"");
        this.m_OptionManager.add("acces-token-secret", "accessTokenSecret", (Object)new BasePassword(""));
    }

    public String getQuickInfo() {
        String result = null;
        String variable = this.getOptionManager().getVariableForProperty("consumerKey");
        if (variable != null) {
            result = variable;
        } else if (this.m_ConsumerKey.length() == 0) {
            result = "anonymous";
        }
        return result;
    }

    public void setConsumerKey(String value) {
        this.m_ConsumerKey = value;
    }

    public String getConsumerKey() {
        return this.m_ConsumerKey;
    }

    public String consumerKeyTipText() {
        return "The twitter consumer key to use for connecting; leave empty for anonymous access.";
    }

    public void setConsumerSecret(BasePassword value) {
        this.m_ConsumerSecret = value;
    }

    public BasePassword getConsumerSecret() {
        return this.m_ConsumerSecret;
    }

    public String consumerSecretTipText() {
        return "The consumer secret of the twitter application to use for connecting.";
    }

    public void setAccessToken(String value) {
        this.m_AccessToken = value;
    }

    public String getAccessToken() {
        return this.m_AccessToken;
    }

    public String accessTokenTipText() {
        return "The twitter access token to use for connecting.";
    }

    public void setAccessTokenSecret(BasePassword value) {
        this.m_AccessTokenSecret = value;
    }

    public BasePassword getAccessTokenSecret() {
        return this.m_AccessTokenSecret;
    }

    public String accessTokenSecretTipText() {
        return "The access token secret of the twitter application to use for connecting.";
    }

    public Twitter getTwitterConnection() {
        Twitter result = new TwitterFactory().getInstance();
        if (this.m_AccessToken.length() > 0) {
            result = new TwitterFactory().getInstance();
            result.setOAuthConsumer(this.m_ConsumerKey, this.m_ConsumerSecret.getValue());
            result.setOAuthAccessToken(new AccessToken(this.m_AccessToken, this.m_AccessTokenSecret.getValue()));
        }
        return result;
    }

    public TwitterStream getTwitterStreamConnection() {
        return new TwitterStreamFactory().getInstance(new AccessToken(this.getAccessToken(), this.getAccessTokenSecret().getValue()));
    }

    protected String doExecute() {
        return null;
    }
}

