/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.apply.ChunkCssApplier;
import com.itextpdf.tool.xml.css.apply.NoNewLineParagraphCssApplier;
import com.itextpdf.tool.xml.css.apply.ParagraphCssApplier;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Div
extends AbstractTagProcessor {
    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        String sanitized = HTMLUtils.sanitizeInline(content);
        ArrayList<Element> l = new ArrayList<Element>(1);
        if (sanitized.length() > 0) {
            Chunk c = new ChunkCssApplier().apply(new Chunk(sanitized), tag);
            try {
                l.add((Element)new NoNewLineParagraphCssApplier(this.getHtmlPipelineContext(ctx)).apply(new NoNewLineParagraph(c), tag));
            }
            catch (NoCustomContextException e) {
                throw new RuntimeWorkerException(e);
            }
        }
        return l;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        try {
            Paragraph p = null;
            ArrayList<Element> l = new ArrayList<Element>(1);
            for (Element e : currentContent) {
                if (e instanceof Paragraph) {
                    if (p != null) {
                        p = new ParagraphCssApplier(this.getHtmlPipelineContext(ctx)).apply(p, tag);
                        l.add((Element)p);
                        p = null;
                    }
                    l.add(e);
                    continue;
                }
                if (p == null) {
                    p = new Paragraph();
                }
                p.add(e);
            }
            if (p != null) {
                p = new ParagraphCssApplier(this.getHtmlPipelineContext(ctx)).apply(p, tag);
                l.add((Element)p);
            }
            return l;
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

