/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayMedian;

public class MultiArrayStatistic<T extends Number>
extends AbstractArrayStatistic<T> {
    private static final long serialVersionUID = 6146460163351963643L;
    protected AbstractArrayStatistic[] m_SubStatistics;

    @Override
    public String globalInfo() {
        return "Merges the spreadsheets generated by its sub-statistics into a single one.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "subStatistics", new AbstractArrayStatistic[]{new ArrayMedian()});
    }

    public void setSubStatistics(AbstractArrayStatistic[] value) {
        this.m_SubStatistics = value;
        this.reset();
    }

    public AbstractArrayStatistic[] getSubStatistics() {
        return this.m_SubStatistics;
    }

    public String subStatisticsTipText() {
        return "The base statistics to accumulate in a single spreadsheet (side-by-side).";
    }

    @Override
    public int getMin() {
        int result = -1;
        for (int i = 0; i < this.m_SubStatistics.length; ++i) {
            if (this.m_SubStatistics[i].getMin() <= result) continue;
            result = this.m_SubStatistics[i].getMin();
        }
        return result;
    }

    @Override
    public int getMax() {
        int result = Integer.MAX_VALUE;
        for (int i = 0; i < this.m_SubStatistics.length; ++i) {
            if (this.m_SubStatistics[i].getMax() == -1 || this.m_SubStatistics[i].getMax() >= result) continue;
            result = this.m_SubStatistics[i].getMax();
        }
        if (result == Integer.MAX_VALUE) {
            result = -1;
        }
        return result;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        int n;
        int i;
        AbstractArrayStatistic.StatisticContainer[] stats = new AbstractArrayStatistic.StatisticContainer[this.m_SubStatistics.length];
        for (i = 0; i < this.m_SubStatistics.length; ++i) {
            AbstractArrayStatistic statistic = this.m_SubStatistics[i].shallowCopy(true);
            for (n = 0; n < this.size(); ++n) {
                statistic.add(this.get(n));
            }
            stats[i] = statistic.calculate();
        }
        int rows = 0;
        int cols = 0;
        for (i = 0; i < stats.length; ++i) {
            cols += stats[i].getColumnCount();
            if (stats[i].getRowCount() <= rows) continue;
            rows = stats[i].getRowCount();
        }
        AbstractArrayStatistic.StatisticContainer result = new AbstractArrayStatistic.StatisticContainer(rows, cols);
        int colOffset = 0;
        for (i = 0; i < stats.length; ++i) {
            for (n = 0; n < stats[i].getColumnCount(); ++n) {
                result.setHeader(colOffset + n, stats[i].getHeader(n));
                for (int m = 0; m < stats[i].getRowCount(); ++m) {
                    result.setCell(m, colOffset + n, stats[i].getCell(m, n));
                }
            }
            colOffset += stats[i].getColumnCount();
        }
        return result;
    }
}

