/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.flow.core.AbstractActor;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.transformer.AnyToCommandline;
import adams.flow.transformer.CommandlineToAny;
import adams.flow.transformer.Convert;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class FixDeprecatedCommandlineTransformers
extends AbstractModifyingProcessor {
    private static final long serialVersionUID = 5428735399970480088L;

    @Override
    public String globalInfo() {
        return "Replaces the deprecated CommandlineToAny and AnyToCommandline transformers with the appropriate Convert transfomer set ups.";
    }

    @Override
    protected void processActor(AbstractActor actor) {
        actor.getOptionManager().traverse(new OptionTraverser(){

            protected void update(AbstractOption option, Object newValue) {
                Method method = option.getDescriptor().getWriteMethod();
                try {
                    method.invoke((Object)option.getOptionHandler(), newValue);
                    FixDeprecatedCommandlineTransformers.this.m_Modified = true;
                }
                catch (Exception e) {
                    System.err.println("Failed to update " + option + ": ");
                    e.printStackTrace();
                }
            }

            protected Convert setupConvert(Object current) {
                Convert result = null;
                if (current instanceof AnyToCommandline) {
                    result = new Convert();
                    result.setConversion(new adams.data.conversion.AnyToCommandline());
                } else if (current instanceof CommandlineToAny) {
                    result = new Convert();
                    result.setConversion(new adams.data.conversion.CommandlineToAny());
                }
                return result;
            }

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
                Object current = option.getCurrentValue();
                if (option.isMultiple()) {
                    boolean updated = false;
                    for (int i = 0; i < Array.getLength(current); ++i) {
                        Object element = Array.get(current, i);
                        Convert convert = this.setupConvert(element);
                        if (convert == null) continue;
                        convert.setName(((AbstractActor)element).getName());
                        Array.set(current, i, convert);
                        updated = true;
                    }
                    if (updated) {
                        this.update(option, current);
                    }
                } else {
                    Convert convert = this.setupConvert(current);
                    if (convert != null) {
                        convert.setName(((AbstractActor)current).getName());
                        this.update(option, convert);
                    }
                }
            }

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
            }

            @Override
            public boolean canRecurse(Class cls) {
                return true;
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }
        });
        if (this.m_Modified) {
            this.m_ModifiedActor = actor;
        }
    }
}

