/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import moa.cluster.Clustering;
import moa.evaluation.MeasureCollection;
import moa.evaluation.MembershipMatrix;
import moa.gui.visualization.DataPoint;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticalCollection
extends MeasureCollection {
    private boolean debug = false;

    @Override
    protected String[] getNames() {
        String[] names = new String[]{"van Dongen", "Rand statistic"};
        return names;
    }

    @Override
    protected boolean[] getDefaultEnabled() {
        boolean[] defaults = new boolean[]{false, false};
        return defaults;
    }

    @Override
    public void evaluateClustering(Clustering clustering, Clustering trueClustering, ArrayList<DataPoint> points) throws Exception {
        MembershipMatrix mm = new MembershipMatrix(clustering, points);
        int numClasses = mm.getNumClasses();
        int numCluster = clustering.size() + 1;
        int n = mm.getTotalEntries();
        double dongenMaxFC = 0.0;
        double dongenMaxSumFC = 0.0;
        for (int i = 0; i < numCluster; ++i) {
            double max = 0.0;
            for (int j = 0; j < numClasses; ++j) {
                if (!((double)mm.getClusterClassWeight(i, j) > max)) continue;
                max = mm.getClusterClassWeight(i, j);
            }
            dongenMaxFC += max;
            if (!((double)mm.getClusterSum(i) > dongenMaxSumFC)) continue;
            dongenMaxSumFC = mm.getClusterSum(i);
        }
        double dongenMaxHC = 0.0;
        double dongenMaxSumHC = 0.0;
        for (int j = 0; j < numClasses; ++j) {
            double max = 0.0;
            for (int i = 0; i < numCluster; ++i) {
                if (!((double)mm.getClusterClassWeight(i, j) > max)) continue;
                max = mm.getClusterClassWeight(i, j);
            }
            dongenMaxHC += max;
            if (!((double)mm.getClassSum(j) > dongenMaxSumHC)) continue;
            dongenMaxSumHC = mm.getClassSum(j);
        }
        double dongen = (dongenMaxFC + dongenMaxHC) / (double)(2 * n);
        if (this.debug) {
            System.out.println("Dongen HC:" + dongenMaxHC + " FC:" + dongenMaxFC + " Total:" + dongen + " n " + n);
        }
        this.addValue("van Dongen", dongen);
        double m1 = 0.0;
        for (int j = 0; j < numClasses; ++j) {
            double v = mm.getClassSum(j);
            m1 += v * (v - 1.0) / 2.0;
        }
        double m2 = 0.0;
        for (int i = 0; i < numCluster; ++i) {
            double v = mm.getClusterSum(i);
            m2 += v * (v - 1.0) / 2.0;
        }
        double m = 0.0;
        for (int i = 0; i < numCluster; ++i) {
            for (int j = 0; j < numClasses; ++j) {
                double v = mm.getClusterClassWeight(i, j);
                m += v * (v - 1.0) / 2.0;
            }
        }
        double M = (double)(n * (n - 1)) / 2.0;
        double rand = (M - m1 - m2 + 2.0 * m) / M;
        this.addValue("Rand statistic", rand);
    }

    public double cindex(Clustering clustering, ArrayList<DataPoint> points) {
        int c;
        int numClusters = clustering.size();
        double withinClustersDistance = 0.0;
        int numDistancesWithin = 0;
        double numDistances = 0.0;
        double[] minWithinClusters = new double[numClusters];
        double[] maxWithinClusters = new double[numClusters];
        ArrayList[] pointsInClusters = new ArrayList[numClusters];
        for (c = 0; c < numClusters; ++c) {
            pointsInClusters[c] = new ArrayList();
            minWithinClusters[c] = Double.MAX_VALUE;
            maxWithinClusters[c] = Double.MIN_VALUE;
        }
        for (int p = 0; p < points.size(); ++p) {
            for (int c2 = 0; c2 < clustering.size(); ++c2) {
                if (!(clustering.get(c2).getInclusionProbability((Instance)points.get(p)) > 0.8)) continue;
                pointsInClusters[c2].add(p);
                numDistances += 1.0;
            }
        }
        for (c = 0; c < numClusters; ++c) {
            int numDistancesInC = 0;
            ArrayList pointsInC = pointsInClusters[c];
            for (int p = 0; p < pointsInC.size(); ++p) {
                DataPoint point = points.get((Integer)pointsInC.get(p));
                for (int p1 = p + 1; p1 < pointsInC.size(); ++p1) {
                    ++numDistancesWithin;
                    ++numDistancesInC;
                    DataPoint point1 = points.get((Integer)pointsInC.get(p1));
                    double dist = point.getDistance(point1);
                    withinClustersDistance += dist;
                    if (minWithinClusters[c] > dist) {
                        minWithinClusters[c] = dist;
                    }
                    if (!(maxWithinClusters[c] < dist)) continue;
                    maxWithinClusters[c] = dist;
                }
            }
        }
        double minWithin = Double.MAX_VALUE;
        double maxWithin = Double.MIN_VALUE;
        for (int c3 = 0; c3 < numClusters; ++c3) {
            if (minWithinClusters[c3] < minWithin) {
                minWithin = minWithinClusters[c3];
            }
            if (!(maxWithinClusters[c3] > maxWithin)) continue;
            maxWithin = maxWithinClusters[c3];
        }
        double cindex = 0.0;
        if (numDistancesWithin != 0) {
            double meanWithinClustersDistance = withinClustersDistance / (double)numDistancesWithin;
            cindex = (meanWithinClustersDistance - minWithin) / (maxWithin - minWithin);
        }
        if (this.debug) {
            System.out.println("Min:" + Arrays.toString(minWithinClusters));
            System.out.println("Max:" + Arrays.toString(maxWithinClusters));
            System.out.println("totalWithin:" + numDistancesWithin);
        }
        return cindex;
    }
}

