/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;

public class BooleanReportValue
extends AbstractBooleanCondition {
    private static final long serialVersionUID = -9169161144858552052L;
    protected Field m_Field;

    @Override
    public String globalInfo() {
        return "Emulates an If-Then-Else construct. The 'Then' branch gets executed if the boolean field in the report is present and is 'true'.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", new Field());
    }

    public void setField(Field value) {
        this.m_Field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The field that determines the result of the evaluation.";
    }

    @Override
    public String getQuickInfo() {
        String result = "boolean report value: ";
        String variable = this.getOptionManager().getVariableForProperty("field");
        result = variable != null ? result + variable : result + this.m_Field.toString();
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{ReportHandler.class, Report.class};
    }

    @Override
    public String setUp() {
        String result = null;
        if (this.m_Field == null) {
            result = "No report field provided!";
        }
        return result;
    }

    @Override
    protected boolean doEvaluate(AbstractActor owner, Token token) {
        boolean result = false;
        Report report = token.getPayload() instanceof ReportHandler ? ((ReportHandler)token.getPayload()).getReport() : (Report)token.getPayload();
        if (report.hasValue(this.m_Field)) {
            result = report.getBooleanValue(this.m_Field);
        }
        return result;
    }
}

