/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.Utils;
import adams.core.io.SpreadSheet;
import adams.gui.core.AbstractBaseTableModel;

public class SpreadSheetTableModel
extends AbstractBaseTableModel {
    private static final long serialVersionUID = 8062515320279133441L;
    protected SpreadSheet m_Sheet;
    protected int m_NumDecimals;

    public SpreadSheetTableModel() {
        this(new SpreadSheet());
    }

    public SpreadSheetTableModel(SpreadSheet sheet) {
        this(sheet, -1);
    }

    public SpreadSheetTableModel(SpreadSheet sheet, int numDec) {
        this.m_Sheet = sheet;
        this.m_NumDecimals = numDec;
    }

    @Override
    public int getRowCount() {
        return this.m_Sheet.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.m_Sheet.getColumnCount() + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        if (columnIndex == 0) {
            result = "Row";
        } else {
            SpreadSheet.Row row = this.m_Sheet.getHeaderRow();
            result = row.getCell(row.getCellKey(columnIndex - 1)).getContent();
        }
        return result;
    }

    public Class getColumnClass(int columnIndex) {
        Class result = columnIndex == 0 ? Integer.class : String.class;
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        if (columnIndex == 0) {
            result = new Integer(rowIndex + 1);
        } else {
            SpreadSheet.Row row = this.m_Sheet.getRow(rowIndex);
            SpreadSheet.Cell cell = row.getCell(this.m_Sheet.getHeaderRow().getCellKey(columnIndex - 1));
            if (cell == null) {
                result = null;
            } else {
                String content = cell.getContent();
                if (cell.isMissing()) {
                    result = null;
                } else if (cell.isLong()) {
                    result = cell.toLong();
                } else if (cell.isDouble()) {
                    double d = cell.toDouble();
                    if (Double.isNaN(d)) {
                        result = "NaN";
                    } else {
                        if (this.m_NumDecimals > -1) {
                            double factor = Math.pow(10.0, this.m_NumDecimals);
                            d = (double)Math.round(d * factor) / factor;
                        }
                        result = Utils.doubleToStringFixed(d, this.m_NumDecimals);
                    }
                } else {
                    result = content;
                }
            }
        }
        return result;
    }

    public SpreadSheet.Cell getCellAt(int rowIndex, int columnIndex) {
        SpreadSheet.Cell result = null;
        if (columnIndex > 0) {
            SpreadSheet.Row row = this.m_Sheet.getRow(rowIndex);
            result = row.getCell(this.m_Sheet.getHeaderRow().getCellKey(columnIndex - 1));
        }
        return result;
    }

    public void setNumDecimals(int value) {
        if (value >= -1) {
            if (this.m_NumDecimals != value) {
                this.m_NumDecimals = value;
                this.fireTableDataChanged();
            }
        } else {
            System.err.println("Number of displayed decimals must be >=0 or -1 to display all - provided: " + value);
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public SpreadSheet getSheet() {
        return this.m_Sheet;
    }
}

