/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree;

import adams.core.DebugHelper;
import adams.core.Properties;
import adams.core.Utils;
import adams.env.Environment;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.transformer.PassThrough;
import java.util.Enumeration;
import java.util.Vector;

public class ActorSuggestion {
    private static final boolean DEBUG = DebugHelper.isDebugOn(ActorSuggestion.class);
    public static final String FILENAME = "ActorSuggestion.props";
    public static final String KEY_DEFAULT = "Default";
    protected Properties m_Properties;
    protected AbstractActor[] m_Defaults;
    protected String[] m_Rules;
    protected static ActorSuggestion m_Singleton;

    private ActorSuggestion() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Properties = Environment.getInstance().read("actor suggestion");
        String[] parts = this.m_Properties.getProperty(KEY_DEFAULT, "adams.flow.transformer.PassThrough").split(",");
        Vector<AbstractActor> actors = new Vector<AbstractActor>();
        for (int i = 0; i < parts.length; ++i) {
            try {
                actors.add((AbstractActor)Class.forName(parts[i]).newInstance());
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate default actor '" + parts[i] + "':");
                e.printStackTrace();
            }
        }
        if (actors.size() == 0) {
            actors.add(new PassThrough());
        }
        this.m_Defaults = actors.toArray(new AbstractActor[actors.size()]);
        if (DEBUG) {
            DebugHelper.debug(this.getClass(), "Defaults: " + Utils.arrayToString(this.m_Defaults, true));
        }
        Vector<String> rules = new Vector<String>();
        Enumeration<?> names = this.m_Properties.propertyNames();
        adams.parser.ActorSuggestion suggestion = new adams.parser.ActorSuggestion();
        suggestion.setParent(new Flow());
        suggestion.setPosition(0);
        suggestion.setActors(new AbstractActor[0]);
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.equals(KEY_DEFAULT)) continue;
            String rule = this.m_Properties.getProperty(name);
            try {
                suggestion.setExpression(rule);
                suggestion.evaluate();
                rules.add(rule);
            }
            catch (Exception e) {
                System.err.println("Invalid actor suggestion rule: " + rule);
                e.printStackTrace();
            }
        }
        this.m_Rules = rules.toArray(new String[rules.size()]);
        if (DEBUG) {
            DebugHelper.debug(this.getClass(), "Rules: " + Utils.arrayToString(this.m_Rules));
        }
    }

    public AbstractActor[] getDefaults() {
        return this.m_Defaults;
    }

    public AbstractActor[] suggest(AbstractActor parent, int position, AbstractActor[] actors) {
        Vector<AbstractActor> suggestions = new Vector<AbstractActor>();
        try {
            AbstractActor[] suggested = adams.parser.ActorSuggestion.evaluate(this.m_Rules, parent, position, actors);
            for (int i = 0; i < suggested.length; ++i) {
                if (suggested[i] == null) continue;
                suggestions.add(suggested[i]);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to suggest actors:");
            e.printStackTrace();
        }
        AbstractActor[] result = suggestions.toArray(new AbstractActor[suggestions.size()]);
        if (DEBUG) {
            DebugHelper.debug(this.getClass(), "suggest: parent=" + parent.getClass().getName() + ", " + "position=" + position + ", " + "actors=" + Utils.arrayToString(actors, true) + "\n" + "--> " + Utils.arrayToString(result, true));
        }
        return result;
    }

    public static synchronized ActorSuggestion getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new ActorSuggestion();
        }
        return m_Singleton;
    }
}

