/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.postprocessor;

import adams.core.ClassLister;
import adams.core.ConsoleObject;
import adams.flow.core.AbstractActor;
import adams.gui.flow.tree.Tree;
import javax.swing.JOptionPane;

public abstract class AbstractEditPostProcessor
extends ConsoleObject {
    private static final long serialVersionUID = -1710283049516306816L;

    public abstract boolean applies(AbstractActor var1, AbstractActor var2, AbstractActor var3);

    public abstract boolean postProcess(Tree var1, AbstractActor var2, AbstractActor var3, AbstractActor var4);

    public static String[] getPostProcessors() {
        return ClassLister.getSingleton().getClassnames(AbstractEditPostProcessor.class);
    }

    public static boolean apply(Tree tree, AbstractActor parent, AbstractActor oldActor, AbstractActor newActor) {
        String[] processors;
        boolean result = false;
        boolean confirmed = false;
        for (String processor : processors = AbstractEditPostProcessor.getPostProcessors()) {
            try {
                AbstractEditPostProcessor proc = (AbstractEditPostProcessor)Class.forName(processor).newInstance();
                if (!proc.applies(parent, oldActor, newActor)) continue;
                if (!confirmed) {
                    if (JOptionPane.showConfirmDialog(tree, "Propagate changes throughout the tree (if applicable)?") != 0) break;
                    confirmed = true;
                }
                result |= proc.postProcess(tree, parent, oldActor, newActor);
            }
            catch (Exception e) {
                System.err.println("Error applying edit post-processor '" + processor + "':");
                e.printStackTrace();
            }
        }
        return result;
    }
}

