/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.URLSourcedLoader;

public class ODFLoader
extends AbstractFileLoader
implements BatchConverter,
URLSourcedLoader,
OptionHandler {
    private static final long serialVersionUID = 9164120515718983413L;
    public static String FILE_EXTENSION = ".ods";
    public static String FILE_DESCRIPTION = "ODF Spreadsheets";
    protected String m_URL = "http://";
    protected transient InputStream m_sourceStream = null;
    protected SpreadSheet m_Spreadsheet;
    protected SingleIndex m_SheetIndex = new SingleIndex("first");
    protected String m_MissingValue = "";

    public String globalInfo() {
        return "Reads a source that is in the ODF spreadsheet format.\nFor instance, a spreadsheet generated with OpenOffice.org.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe index of the sheet to load; 'first' and 'last' are accepted as well.", "sheet", 1, "-sheet <index>"));
        result.addElement(new Option("\tThe string representing a missing value.\n\t(default: '')", "M", 1, "-M <str>"));
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-sheet");
        result.add(this.getSheetIndex());
        result.add("-M");
        result.add(this.getMissingValue());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"sheet", (String[])options);
        if (tmpStr.length() > 0) {
            this.setSheetIndex(tmpStr);
        }
        if ((tmpStr = Utils.getOption((char)'M', (String[])options)).length() != 0) {
            this.setMissingValue(tmpStr);
        }
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The placeholder for missing values, default is '' (empty cell).";
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{FILE_EXTENSION};
    }

    public String getFileDescription() {
        return FILE_DESCRIPTION;
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.m_Spreadsheet = null;
        this.m_SheetIndex.setSingleIndex("first");
        this.setRetrieval(0);
        if (this.m_File != null) {
            this.setFile(new File(this.m_File));
        } else if (this.m_URL != null && !this.m_URL.equals("http://")) {
            this.setURL(this.m_URL);
        }
    }

    public void setSheetIndex(String value) {
        this.m_SheetIndex.setSingleIndex(value);
    }

    public String getSheetIndex() {
        return this.m_SheetIndex.getSingleIndex();
    }

    public String sheetIndexTipText() {
        return "The 1-based index of the sheet to load; 'first' and 'last' are accepted as well.";
    }

    public void setSource(URL url) throws IOException {
        this.m_structure = null;
        this.m_Spreadsheet = null;
        this.setRetrieval(0);
        this.setSource(url.openStream());
        this.m_URL = url.toString();
    }

    public void setURL(String url) throws IOException {
        this.m_URL = url;
        this.setSource(new URL(url));
    }

    public String retrieveURL() {
        return this.m_URL;
    }

    public void setSource(InputStream in) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_URL = "http://";
        this.m_sourceStream = new BufferedInputStream(in);
    }

    public Instances getStructure() throws IOException {
        if (this.m_sourceStream == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            try {
                this.m_Spreadsheet = SpreadSheet.create((ODPackage)new ODPackage(this.m_sourceStream));
                this.m_SheetIndex.setUpper(this.m_Spreadsheet.getSheetCount() - 1);
                Sheet sheet = this.m_Spreadsheet.getSheet(this.m_SheetIndex.getIndex());
                ArrayList<Attribute> atts = new ArrayList<Attribute>();
                for (int i = 0; i < sheet.getColumnCount() && sheet.getCellAt(i, 0).getTextValue().length() != 0; ++i) {
                    String cellStr = sheet.getCellAt(i, 0).getTextValue();
                    if (cellStr.length() == 0) {
                        atts.add(new Attribute("column-" + (i + 1)));
                        continue;
                    }
                    atts.add(new Attribute(cellStr));
                }
                this.m_structure = new Instances("WekaODF", atts, 0);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new Instances(this.m_structure, 0);
    }

    protected Object convert(String cell) {
        Object result;
        try {
            result = Integer.parseInt(cell);
        }
        catch (Exception e) {
            try {
                result = Double.parseDouble(cell);
            }
            catch (Exception ex) {
                result = cell;
            }
        }
        return result;
    }

    public Instances getDataSet() throws IOException {
        if (this.m_sourceStream == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        Instances result = null;
        try {
            int n;
            Vector<Object[]> data = new Vector<Object[]>();
            boolean newHeader = false;
            int[] attType = new int[this.m_structure.numAttributes()];
            this.m_SheetIndex.setUpper(this.m_Spreadsheet.getSheetCount() - 1);
            Sheet sheet = this.m_Spreadsheet.getSheet(this.m_SheetIndex.getIndex());
            for (int n2 = 1; n2 < sheet.getRowCount(); ++n2) {
                int i;
                Object[] row = new Object[this.m_structure.numAttributes()];
                boolean empty = true;
                for (i = 0; i < row.length; ++i) {
                    row[i] = sheet.getCellAt(i, n2).getValue();
                    if (sheet.getCellAt(i, n2).getTextValue().length() > 0) {
                        empty = false;
                    }
                    if (!sheet.getCellAt(i, n2).getTextValue().equals(this.m_MissingValue)) continue;
                    row[i] = null;
                }
                if (empty) break;
                for (i = 0; i < row.length; ++i) {
                    if (sheet.getCellAt(i, n2).getValueType() == ODValueType.FLOAT) continue;
                    attType[i] = 1;
                    newHeader = true;
                }
                data.add(row);
            }
            if (newHeader) {
                ArrayList<Attribute> atts = new ArrayList<Attribute>();
                for (int i = 0; i < attType.length; ++i) {
                    if (attType[i] == 0) {
                        atts.add(new Attribute(this.m_structure.attribute(i).name()));
                        continue;
                    }
                    if (attType[i] == 1) {
                        HashSet<String> strings = new HashSet<String>();
                        for (n = 0; n < data.size(); ++n) {
                            if (((Object[])data.get(n))[i] == null || ((Object[])data.get(n))[i].toString().equals(this.m_MissingValue)) continue;
                            strings.add(((Object[])data.get(n))[i].toString());
                        }
                        ArrayList attValues = new ArrayList(strings);
                        Collections.sort(attValues);
                        atts.add(new Attribute(this.m_structure.attribute(i).name(), attValues));
                        continue;
                    }
                    throw new IllegalStateException("Unhandlded attribute type: " + attType[i]);
                }
                this.m_structure = new Instances("WekaODF", atts, 0);
            }
            result = new Instances(this.m_structure, data.size());
            for (int i = 0; i < data.size(); ++i) {
                double[] values = new double[this.m_structure.numAttributes()];
                Object[] dataRow = (Object[])data.get(i);
                for (n = 0; n < dataRow.length; ++n) {
                    if (dataRow[n] == null) {
                        values[n] = Utils.missingValue();
                        continue;
                    }
                    if (attType[n] == 1) {
                        values[n] = this.m_structure.attribute(n).indexOfValue(dataRow[n].toString());
                        continue;
                    }
                    if (attType[n] == 0) {
                        values[n] = ((Number)dataRow[n]).doubleValue();
                        continue;
                    }
                    throw new IllegalStateException("Unhandlded attribute type: " + attType[n]);
                }
                DenseInstance inst = new DenseInstance(1.0, values);
                result.add((Instance)inst);
            }
            this.m_sourceStream.close();
        }
        catch (Exception ex) {
            System.err.println("Failed to load ODF document");
            ex.printStackTrace();
        }
        return result;
    }

    public Instance getNextInstance(Instances structure) throws IOException {
        throw new IOException("ODFLoader can't read data sets incrementally.");
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 8109 $");
    }

    public static void main(String[] args) {
        ODFLoader.runFileLoader((AbstractFileLoader)new ODFLoader(), (String[])args);
    }
}

