/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.ArrayMath;
import JSci.maths.ExtraMath;
import JSci.maths.LinearMath;
import JSci.maths.Mapping;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.matrices.DoubleDiagonalMatrix;
import JSci.maths.matrices.DoubleLUCache;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.matrices.IntegerSquareMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.matrices.SquareMatrix;
import JSci.maths.vectors.AbstractDoubleVector;

public abstract class AbstractDoubleSquareMatrix
extends AbstractDoubleMatrix
implements SquareMatrix {
    protected transient DoubleLUCache luCache;

    protected AbstractDoubleSquareMatrix(int n) {
        super(n, n);
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                nArray[i][j] = Math.round((float)this.getElement(i, j));
            }
        }
        return new IntegerSquareMatrix(nArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        ComplexSquareMatrix complexSquareMatrix = new ComplexSquareMatrix(this.numRows);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                complexSquareMatrix.setElement(i, j, this.getElement(i, j), 0.0);
            }
        }
        return complexSquareMatrix;
    }

    public boolean isSymmetric() {
        return this.equals(this.transpose());
    }

    public boolean isUnitary() {
        return this.multiply(this.transpose()).equals(DoubleDiagonalMatrix.identity(this.numRows));
    }

    public double det() {
        if (this.numRows == 2) {
            return this.getElement(0, 0) * this.getElement(1, 1) - this.getElement(0, 1) * this.getElement(1, 0);
        }
        int[] nArray = new int[this.numRows + 1];
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = this.luDecompose(nArray);
        double d = abstractDoubleSquareMatrixArray[1].getElement(0, 0);
        for (int i = 1; i < this.numRows; ++i) {
            d *= abstractDoubleSquareMatrixArray[1].getElement(i, i);
        }
        return d * (double)nArray[this.numRows];
    }

    public double trace() {
        double d = this.getElement(0, 0);
        for (int i = 1; i < this.numRows; ++i) {
            d += this.getElement(i, i);
        }
        return d;
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveSymmetric((AbstractDoubleSquareMatrix)this.transpose().multiply(this))));
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = -this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = -this.getElement(i, j);
            }
        }
        return new DoubleSquareMatrix(dArray);
    }

    public final AbstractDoubleMatrix add(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof AbstractDoubleSquareMatrix) {
            return this.add((AbstractDoubleSquareMatrix)abstractDoubleMatrix);
        }
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            return this.add(new SquareMatrixAdaptor(abstractDoubleMatrix));
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleSquareMatrix add(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.getElement(i, 0) + abstractDoubleSquareMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.getElement(i, j) + abstractDoubleSquareMatrix.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final AbstractDoubleMatrix subtract(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof AbstractDoubleSquareMatrix) {
            return this.subtract((AbstractDoubleSquareMatrix)abstractDoubleMatrix);
        }
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            return this.subtract(new SquareMatrixAdaptor(abstractDoubleMatrix));
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleSquareMatrix subtract(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.getElement(i, 0) - abstractDoubleSquareMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.getElement(i, j) - abstractDoubleSquareMatrix.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = d * this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = d * this.getElement(i, j);
            }
        }
        return new DoubleSquareMatrix(dArray);
    }

    public AbstractDoubleMatrix scalarDivide(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = this.getElement(i, 0) / d;
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = this.getElement(i, j) / d;
            }
        }
        return new DoubleSquareMatrix(dArray);
    }

    public final double scalarProduct(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof AbstractDoubleSquareMatrix) {
            return this.scalarProduct((AbstractDoubleSquareMatrix)abstractDoubleMatrix);
        }
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            return this.scalarProduct(new SquareMatrixAdaptor(abstractDoubleMatrix));
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (this.numRows == abstractDoubleSquareMatrix.rows() && this.numCols == abstractDoubleSquareMatrix.columns()) {
            double d = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                d += this.getElement(i, 0) * abstractDoubleSquareMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    d += this.getElement(i, j) * abstractDoubleSquareMatrix.getElement(i, j);
                }
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleSquareMatrix multiply(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        if (this.numCols == abstractDoubleSquareMatrix.rows()) {
            int n = abstractDoubleSquareMatrix.columns();
            double[][] dArray = new double[this.numRows][n];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray[i][j] = this.getElement(i, 0) * abstractDoubleSquareMatrix.getElement(0, j);
                    for (int k = 1; k < this.numCols; ++k) {
                        double[] dArray2 = dArray[i];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + this.getElement(i, k) * abstractDoubleSquareMatrix.getElement(k, j);
                    }
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleSquareMatrix directSum(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        int n;
        int n2;
        double[][] dArray = new double[this.numRows + abstractDoubleSquareMatrix.numRows][this.numCols + abstractDoubleSquareMatrix.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                dArray[n2][n] = this.getElement(n2, n);
            }
        }
        for (n2 = 0; n2 < abstractDoubleSquareMatrix.numRows; ++n2) {
            for (n = 0; n < abstractDoubleSquareMatrix.numCols; ++n) {
                dArray[n2 + this.numRows][n + this.numCols] = abstractDoubleSquareMatrix.getElement(n2, n);
            }
        }
        return new DoubleSquareMatrix(dArray);
    }

    public AbstractDoubleSquareMatrix tensor(AbstractDoubleSquareMatrix abstractDoubleSquareMatrix) {
        double[][] dArray = new double[this.numRows * abstractDoubleSquareMatrix.numRows][this.numCols * abstractDoubleSquareMatrix.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n = 0;
                while (n < abstractDoubleSquareMatrix.numRows) {
                    for (int k = 0; k < abstractDoubleSquareMatrix.numCols; ++k) {
                        dArray[i * abstractDoubleSquareMatrix.numRows + n][j * abstractDoubleSquareMatrix.numCols + k] = this.getElement(i, j) * abstractDoubleSquareMatrix.getElement(n, k);
                    }
                    ++j;
                }
            }
        }
        return new DoubleSquareMatrix(dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[0][i] = this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[j][i] = this.getElement(i, j);
            }
        }
        return new DoubleSquareMatrix(dArray);
    }

    public AbstractDoubleSquareMatrix inverse() {
        int n;
        int n2;
        int n3 = this.numRows;
        double[][] dArray = new double[n3][n3];
        double[][] dArray2 = new double[n3][n3];
        int[] nArray = new int[this.numRows + 1];
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = this.luDecompose(nArray);
        dArray[0][0] = 1.0 / abstractDoubleSquareMatrixArray[0].getElement(0, 0);
        dArray2[0][0] = 1.0 / abstractDoubleSquareMatrixArray[1].getElement(0, 0);
        for (n2 = 1; n2 < n3; ++n2) {
            dArray[n2][n2] = 1.0 / abstractDoubleSquareMatrixArray[0].getElement(n2, n2);
            dArray2[n2][n2] = 1.0 / abstractDoubleSquareMatrixArray[1].getElement(n2, n2);
        }
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            for (n = n2 + 1; n < n3; ++n) {
                double d = 0.0;
                double d2 = 0.0;
                for (int i = n2; i < n; ++i) {
                    d -= abstractDoubleSquareMatrixArray[0].getElement(n, i) * dArray[i][n2];
                    d2 -= dArray2[n2][i] * abstractDoubleSquareMatrixArray[1].getElement(i, n);
                }
                dArray[n][n2] = d / abstractDoubleSquareMatrixArray[0].getElement(n, n);
                dArray2[n2][n] = d2 / abstractDoubleSquareMatrixArray[1].getElement(n, n);
            }
        }
        double[][] dArray3 = new double[n3][n3];
        for (n = 0; n < n3; ++n) {
            int n4;
            int n5;
            for (n5 = 0; n5 < n; ++n5) {
                for (n4 = n; n4 < n3; ++n4) {
                    double[] dArray4 = dArray3[n];
                    int n6 = nArray[n5];
                    dArray4[n6] = dArray4[n6] + dArray2[n][n4] * dArray[n4][n5];
                }
            }
            for (n5 = n; n5 < n3; ++n5) {
                for (n4 = n5; n4 < n3; ++n4) {
                    double[] dArray5 = dArray3[n];
                    int n7 = nArray[n5];
                    dArray5[n7] = dArray5[n7] + dArray2[n][n4] * dArray[n4][n5];
                }
            }
        }
        return new DoubleSquareMatrix(dArray3);
    }

    public AbstractDoubleSquareMatrix[] luDecompose(int[] nArray) {
        int n;
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = this.luDecompose_cache(nArray);
        if (abstractDoubleSquareMatrixArray != null) {
            return abstractDoubleSquareMatrixArray;
        }
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        if (nArray == null) {
            nArray = new int[n2 + 1];
        }
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        nArray[n2] = 1;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n; ++i) {
                double d = this.getElement(nArray[i], n);
                for (int j = 0; j < i; ++j) {
                    d -= dArray2[i][j] * dArray2[j][n];
                }
                dArray2[i][n] = d;
            }
            double d = 0.0;
            int n3 = n;
            for (int i = n; i < n2; ++i) {
                double d2 = this.getElement(nArray[i], n);
                for (int j = 0; j < n; ++j) {
                    d2 -= dArray2[i][j] * dArray2[j][n];
                }
                dArray2[i][n] = d2;
                if (!((d2 = Math.abs(d2)) > d)) continue;
                d = d2;
                n3 = i;
            }
            if (n3 != n) {
                double[] dArray3 = dArray2[n];
                dArray2[n] = dArray2[n3];
                dArray2[n3] = dArray3;
                int n4 = nArray[n];
                nArray[n] = nArray[n3];
                nArray[n3] = n4;
                nArray[n2] = -nArray[n2];
            }
            double d3 = dArray2[n][n];
            for (int i = n + 1; i < n2; ++i) {
                double[] dArray4 = dArray2[i];
                int n5 = n;
                dArray4[n5] = dArray4[n5] / d3;
            }
        }
        for (n = 0; n < n2; ++n) {
            dArray[n][n] = 1.0;
            for (int i = n + 1; i < n2; ++i) {
                dArray[i][n] = dArray2[i][n];
                dArray2[i][n] = 0.0;
            }
        }
        DoubleSquareMatrix doubleSquareMatrix = new DoubleSquareMatrix(dArray);
        DoubleSquareMatrix doubleSquareMatrix2 = new DoubleSquareMatrix(dArray2);
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.luCache = new DoubleLUCache(doubleSquareMatrix, doubleSquareMatrix2, nArray2);
        return new AbstractDoubleSquareMatrix[]{doubleSquareMatrix, doubleSquareMatrix2};
    }

    protected AbstractDoubleSquareMatrix[] luDecompose_cache(int[] nArray) {
        if (this.luCache != null) {
            AbstractDoubleSquareMatrix abstractDoubleSquareMatrix = this.luCache.getL();
            AbstractDoubleSquareMatrix abstractDoubleSquareMatrix2 = this.luCache.getU();
            if (abstractDoubleSquareMatrix != null && abstractDoubleSquareMatrix2 != null) {
                if (nArray == null) {
                    return new AbstractDoubleSquareMatrix[]{abstractDoubleSquareMatrix, abstractDoubleSquareMatrix2};
                }
                int[] nArray2 = this.luCache.getPivot();
                if (nArray2 != null) {
                    System.arraycopy(nArray2, 0, nArray, 0, nArray.length);
                    return new AbstractDoubleSquareMatrix[]{abstractDoubleSquareMatrix, abstractDoubleSquareMatrix2};
                }
            }
            this.luCache = null;
        }
        return null;
    }

    public AbstractDoubleSquareMatrix[] luDecompose() {
        int n;
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        for (n = 0; n < n2; ++n) {
            int n3;
            double d;
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                d = this.getElement(n4, n);
                for (n3 = 0; n3 < n4; ++n3) {
                    d -= dArray2[n4][n3] * dArray2[n3][n];
                }
                dArray2[n4][n] = d;
            }
            for (n4 = n; n4 < n2; ++n4) {
                d = this.getElement(n4, n);
                for (n3 = 0; n3 < n; ++n3) {
                    d -= dArray2[n4][n3] * dArray2[n3][n];
                }
                dArray2[n4][n] = d;
            }
            double d2 = dArray2[n][n];
            for (int i = n + 1; i < n2; ++i) {
                double[] dArray3 = dArray2[i];
                int n5 = n;
                dArray3[n5] = dArray3[n5] / d2;
            }
        }
        for (n = 0; n < n2; ++n) {
            dArray[n][n] = 1.0;
            for (int i = n + 1; i < n2; ++i) {
                dArray[i][n] = dArray2[i][n];
                dArray2[i][n] = 0.0;
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        int n;
        double d;
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double d2 = d = Math.sqrt(this.getElement(0, 0));
        dArray2[0][0] = d2;
        dArray[0][0] = d2;
        for (n = 1; n < n2; ++n) {
            double d3 = this.getElement(n, 0) / d;
            dArray2[0][n] = d3;
            dArray[n][0] = d3;
        }
        for (n = 1; n < n2; ++n) {
            int n3;
            d = this.getElement(n, n);
            for (n3 = 0; n3 < n; ++n3) {
                d -= dArray[n][n3] * dArray[n][n3];
            }
            double d4 = Math.sqrt(d);
            dArray2[n][n] = d4;
            dArray[n][n] = d4;
            for (n3 = n + 1; n3 < n2; ++n3) {
                d = this.getElement(n3, n);
                for (int i = 0; i < n3; ++i) {
                    d -= dArray[n][i] * dArray2[i][n3];
                }
                double d5 = d / dArray2[n][n];
                dArray2[n][n3] = d5;
                dArray[n3][n] = d5;
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] qrDecompose() {
        int n;
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double[][] dArray3 = new double[n2][n2];
        for (n = 0; n < n2; ++n) {
            dArray[n][0] = this.getElement(n, 0);
            for (int i = 1; i < n2; ++i) {
                dArray[n][i] = this.getElement(n, i);
            }
        }
        for (n = 0; n < n2; ++n) {
            int n3;
            double d = dArray[n][n];
            for (n3 = n + 1; n3 < n2; ++n3) {
                d = ExtraMath.hypot(d, dArray[n3][n]);
            }
            if (d != 0.0) {
                if (dArray[n][n] < 0.0) {
                    d = -d;
                }
                for (n3 = n; n3 < n2; ++n3) {
                    double[] dArray4 = dArray[n3];
                    int n4 = n;
                    dArray4[n4] = dArray4[n4] / d;
                }
                double[] dArray5 = dArray[n];
                int n5 = n;
                dArray5[n5] = dArray5[n5] + 1.0;
                for (n3 = n + 1; n3 < n2; ++n3) {
                    int n6;
                    double d2 = dArray[n][n] * dArray[n][n3];
                    for (n6 = n + 1; n6 < n2; ++n6) {
                        d2 += dArray[n6][n] * dArray[n6][n3];
                    }
                    d2 /= dArray[n][n];
                    for (n6 = n; n6 < n2; ++n6) {
                        double[] dArray6 = dArray[n6];
                        int n7 = n3;
                        dArray6[n7] = dArray6[n7] - d2 * dArray[n6][n];
                    }
                }
            }
            dArray3[n][n] = -d;
        }
        for (n = n2 - 1; n >= 0; --n) {
            dArray2[n][n] = 1.0;
            for (int i = n; i < n2; ++i) {
                int n8;
                if (dArray[n][n] == 0.0) continue;
                double d = dArray[n][n] * dArray2[n][i];
                for (n8 = n + 1; n8 < n2; ++n8) {
                    d += dArray[n8][n] * dArray2[n8][i];
                }
                d /= dArray[n][n];
                for (n8 = n; n8 < n2; ++n8) {
                    double[] dArray7 = dArray2[n8];
                    int n9 = i;
                    dArray7[n9] = dArray7[n9] - d * dArray[n8][n];
                }
            }
        }
        for (n = 0; n < n2; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                dArray3[n][i] = dArray[n][i];
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray2), new DoubleSquareMatrix(dArray3)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] singularValueDecompose() {
        int n;
        double d;
        int n2;
        int n3;
        int n4;
        int n5 = this.numRows;
        int n6 = n5 - 1;
        double[][] dArray = new double[n5][n5];
        double[][] dArray2 = new double[n5][n5];
        double[] dArray3 = new double[n5];
        double[][] dArray4 = new double[n5][n5];
        double[] dArray5 = new double[n5];
        double[] dArray6 = new double[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            dArray[n4][0] = this.getElement(n4, 0);
            for (n3 = 1; n3 < n5; ++n3) {
                dArray[n4][n3] = this.getElement(n4, n3);
            }
        }
        for (n4 = 0; n4 < n6; ++n4) {
            dArray3[n4] = dArray[n4][n4];
            for (n3 = n4 + 1; n3 < n5; ++n3) {
                dArray3[n4] = ExtraMath.hypot(dArray3[n4], dArray[n3][n4]);
            }
            if (dArray3[n4] != 0.0) {
                if (dArray[n4][n4] < 0.0) {
                    dArray3[n4] = -dArray3[n4];
                }
                for (n3 = n4; n3 < n5; ++n3) {
                    double[] dArray7 = dArray[n3];
                    int n7 = n4;
                    dArray7[n7] = dArray7[n7] / dArray3[n4];
                }
                double[] dArray8 = dArray[n4];
                int n8 = n4;
                dArray8[n8] = dArray8[n8] + 1.0;
            }
            dArray3[n4] = -dArray3[n4];
            for (n3 = n4 + 1; n3 < n5; ++n3) {
                if (dArray3[n4] != 0.0) {
                    double d2 = dArray[n4][n4] * dArray[n4][n3];
                    for (n2 = n4 + 1; n2 < n5; ++n2) {
                        d2 += dArray[n2][n4] * dArray[n2][n3];
                    }
                    d2 /= dArray[n4][n4];
                    for (n2 = n4; n2 < n5; ++n2) {
                        double[] dArray9 = dArray[n2];
                        int n9 = n3;
                        dArray9[n9] = dArray9[n9] - d2 * dArray[n2][n4];
                    }
                }
                dArray5[n3] = dArray[n4][n3];
            }
            for (n3 = n4; n3 < n5; ++n3) {
                dArray2[n3][n4] = dArray[n3][n4];
            }
            if (n4 >= n5 - 2) continue;
            dArray5[n4] = dArray5[n4 + 1];
            for (n3 = n4 + 2; n3 < n5; ++n3) {
                dArray5[n4] = ExtraMath.hypot(dArray5[n4], dArray5[n3]);
            }
            if (dArray5[n4] != 0.0) {
                if (dArray5[n4 + 1] < 0.0) {
                    dArray5[n4] = -dArray5[n4];
                }
                n3 = n4 + 1;
                while (n3 < n5) {
                    int n10 = n3++;
                    dArray5[n10] = dArray5[n10] / dArray5[n4];
                }
                int n11 = n4 + 1;
                dArray5[n11] = dArray5[n11] + 1.0;
            }
            dArray5[n4] = -dArray5[n4];
            if (dArray5[n4] != 0.0) {
                for (n3 = n4 + 1; n3 < n5; ++n3) {
                    dArray6[n3] = 0.0;
                    for (int i = n4 + 1; i < n5; ++i) {
                        int n12 = n3;
                        dArray6[n12] = dArray6[n12] + dArray5[i] * dArray[n3][i];
                    }
                }
                for (n3 = n4 + 1; n3 < n5; ++n3) {
                    double d3 = dArray5[n3] / dArray5[n4 + 1];
                    for (n2 = n4 + 1; n2 < n5; ++n2) {
                        double[] dArray10 = dArray[n2];
                        int n13 = n3;
                        dArray10[n13] = dArray10[n13] - d3 * dArray6[n2];
                    }
                }
            }
            for (n3 = n4 + 1; n3 < n5; ++n3) {
                dArray4[n3][n4] = dArray5[n3];
            }
        }
        n4 = n5;
        dArray3[n6] = dArray[n6][n6];
        dArray5[n5 - 2] = dArray[n5 - 2][n6];
        dArray5[n6] = 0.0;
        dArray2[n6][n6] = 1.0;
        for (n3 = n5 - 2; n3 >= 0; --n3) {
            int n14;
            if (dArray3[n3] != 0.0) {
                for (n14 = n3 + 1; n14 < n5; ++n14) {
                    d = dArray2[n3][n3] * dArray2[n3][n14];
                    for (n = n3 + 1; n < n5; ++n) {
                        d += dArray2[n][n3] * dArray2[n][n14];
                    }
                    d /= dArray2[n3][n3];
                    for (n = n3; n < n5; ++n) {
                        double[] dArray11 = dArray2[n];
                        int n15 = n14;
                        dArray11[n15] = dArray11[n15] - d * dArray2[n][n3];
                    }
                }
                for (n14 = n3; n14 < n5; ++n14) {
                    dArray2[n14][n3] = -dArray2[n14][n3];
                }
                double[] dArray12 = dArray2[n3];
                int n16 = n3;
                dArray12[n16] = dArray12[n16] + 1.0;
                for (n14 = 0; n14 < n3 - 1; ++n14) {
                    dArray2[n14][n3] = 0.0;
                }
                continue;
            }
            for (n14 = 0; n14 < n5; ++n14) {
                dArray2[n14][n3] = 0.0;
            }
            dArray2[n3][n3] = 1.0;
        }
        for (n3 = n6; n3 >= 0; --n3) {
            int n17;
            if (n3 < n5 - 2 && dArray5[n3] != 0.0) {
                for (n17 = n3 + 1; n17 < n5; ++n17) {
                    d = dArray4[n3 + 1][n3] * dArray4[n3 + 1][n17];
                    for (n = n3 + 2; n < n5; ++n) {
                        d += dArray4[n][n3] * dArray4[n][n17];
                    }
                    d /= dArray4[n3 + 1][n3];
                    for (n = n3 + 1; n < n5; ++n) {
                        double[] dArray13 = dArray4[n];
                        int n18 = n17;
                        dArray13[n18] = dArray13[n18] - d * dArray4[n][n3];
                    }
                }
            }
            for (n17 = 0; n17 < n5; ++n17) {
                dArray4[n17][n3] = 0.0;
            }
            dArray4[n3][n3] = 1.0;
        }
        double d4 = Math.pow(2.0, -52.0);
        int n19 = 0;
        block34: while (n4 > 0) {
            int n20;
            for (n2 = n4 - 2; n2 >= -1 && n2 != -1; --n2) {
                if (!(Math.abs(dArray5[n2]) <= d4 * (Math.abs(dArray3[n2]) + Math.abs(dArray3[n2 + 1])))) continue;
                dArray5[n2] = 0.0;
                break;
            }
            if (n2 == n4 - 2) {
                n = 4;
            } else {
                for (n20 = n4 - 1; n20 >= n2 && n20 != n2; --n20) {
                    double d5 = (n20 != n4 ? Math.abs(dArray5[n20]) : 0.0) + (n20 != n2 + 1 ? Math.abs(dArray5[n20 - 1]) : 0.0);
                    if (!(Math.abs(dArray3[n20]) <= d4 * d5)) continue;
                    dArray3[n20] = 0.0;
                    break;
                }
                if (n20 == n2) {
                    n = 3;
                } else if (n20 == n4 - 1) {
                    n = 1;
                } else {
                    n = 2;
                    n2 = n20;
                }
            }
            ++n2;
            switch (n) {
                case 1: {
                    int n21;
                    double d6;
                    double d7;
                    double d8;
                    double d9 = dArray5[n4 - 2];
                    dArray5[n4 - 2] = 0.0;
                    for (int i = n4 - 2; i >= n2; --i) {
                        d8 = ExtraMath.hypot(dArray3[i], d9);
                        d7 = dArray3[i] / d8;
                        d6 = d9 / d8;
                        dArray3[i] = d8;
                        if (i != n2) {
                            d9 = -d6 * dArray5[i - 1];
                            int n22 = i - 1;
                            dArray5[n22] = dArray5[n22] * d7;
                        }
                        for (n21 = 0; n21 < n5; ++n21) {
                            d8 = d7 * dArray4[n21][i] + d6 * dArray4[n21][n4 - 1];
                            dArray4[n21][n4 - 1] = -d6 * dArray4[n21][i] + d7 * dArray4[n21][n4 - 1];
                            dArray4[n21][i] = d8;
                        }
                    }
                    continue block34;
                }
                case 2: {
                    int n21;
                    double d6;
                    double d7;
                    double d8;
                    double d10 = dArray5[n2 - 1];
                    dArray5[n2 - 1] = 0.0;
                    for (int i = n2; i < n4; ++i) {
                        d8 = ExtraMath.hypot(dArray3[i], d10);
                        d7 = dArray3[i] / d8;
                        d6 = d10 / d8;
                        dArray3[i] = d8;
                        d10 = -d6 * dArray5[i];
                        int n23 = i;
                        dArray5[n23] = dArray5[n23] * d7;
                        for (n21 = 0; n21 < n5; ++n21) {
                            d8 = d7 * dArray2[n21][i] + d6 * dArray2[n21][n2 - 1];
                            dArray2[n21][n2 - 1] = -d6 * dArray2[n21][i] + d7 * dArray2[n21][n2 - 1];
                            dArray2[n21][i] = d8;
                        }
                    }
                    continue block34;
                }
                case 3: {
                    double d11 = Math.max(Math.max(Math.max(Math.max(Math.abs(dArray3[n4 - 1]), Math.abs(dArray3[n4 - 2])), Math.abs(dArray5[n4 - 2])), Math.abs(dArray3[n2])), Math.abs(dArray5[n2]));
                    double d12 = dArray3[n4 - 1] / d11;
                    double d13 = dArray3[n4 - 2] / d11;
                    double d14 = dArray5[n4 - 2] / d11;
                    double d15 = dArray3[n2] / d11;
                    double d16 = dArray5[n2] / d11;
                    double d17 = ((d13 + d12) * (d13 - d12) + d14 * d14) / 2.0;
                    double d18 = d12 * d14 * (d12 * d14);
                    double d19 = 0.0;
                    if (d17 != 0.0 || d18 != 0.0) {
                        d19 = Math.sqrt(d17 * d17 + d18);
                        if (d17 < 0.0) {
                            d19 = -d19;
                        }
                        d19 = d18 / (d17 + d19);
                    }
                    double d20 = (d15 + d12) * (d15 - d12) + d19;
                    double d21 = d15 * d16;
                    for (int i = n2; i < n4 - 1; ++i) {
                        int n24;
                        double d22 = ExtraMath.hypot(d20, d21);
                        double d23 = d20 / d22;
                        double d24 = d21 / d22;
                        if (i != n2) {
                            dArray5[i - 1] = d22;
                        }
                        d20 = d23 * dArray3[i] + d24 * dArray5[i];
                        dArray5[i] = d23 * dArray5[i] - d24 * dArray3[i];
                        d21 = d24 * dArray3[i + 1];
                        int n25 = i + 1;
                        dArray3[n25] = dArray3[n25] * d23;
                        for (n24 = 0; n24 < n5; ++n24) {
                            d22 = d23 * dArray4[n24][i] + d24 * dArray4[n24][i + 1];
                            dArray4[n24][i + 1] = -d24 * dArray4[n24][i] + d23 * dArray4[n24][i + 1];
                            dArray4[n24][i] = d22;
                        }
                        d22 = ExtraMath.hypot(d20, d21);
                        d23 = d20 / d22;
                        d24 = d21 / d22;
                        dArray3[i] = d22;
                        d20 = d23 * dArray5[i] + d24 * dArray3[i + 1];
                        dArray3[i + 1] = -d24 * dArray5[i] + d23 * dArray3[i + 1];
                        d21 = d24 * dArray5[i + 1];
                        int n26 = i + 1;
                        dArray5[n26] = dArray5[n26] * d23;
                        if (i >= n6) continue;
                        for (n24 = 0; n24 < n5; ++n24) {
                            d22 = d23 * dArray2[n24][i] + d24 * dArray2[n24][i + 1];
                            dArray2[n24][i + 1] = -d24 * dArray2[n24][i] + d23 * dArray2[n24][i + 1];
                            dArray2[n24][i] = d22;
                        }
                    }
                    dArray5[n4 - 2] = d20;
                    ++n19;
                    break;
                }
                case 4: {
                    if (dArray3[n2] <= 0.0) {
                        dArray3[n2] = -dArray3[n2];
                        for (n20 = 0; n20 < n4; ++n20) {
                            dArray4[n20][n2] = -dArray4[n20][n2];
                        }
                    }
                    while (n2 < n4 - 1 && !(dArray3[n2] >= dArray3[n2 + 1])) {
                        double d25 = dArray3[n2];
                        dArray3[n2] = dArray3[n2 + 1];
                        dArray3[n2 + 1] = d25;
                        if (n2 < n6) {
                            for (int i = 0; i < n5; ++i) {
                                d25 = dArray2[i][n2 + 1];
                                dArray2[i][n2 + 1] = dArray2[i][n2];
                                dArray2[i][n2] = d25;
                                d25 = dArray4[i][n2 + 1];
                                dArray4[i][n2 + 1] = dArray4[i][n2];
                                dArray4[i][n2] = d25;
                            }
                        }
                        ++n2;
                    }
                    n19 = 0;
                    --n4;
                }
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray2), new DoubleDiagonalMatrix(dArray3), new DoubleSquareMatrix(dArray4)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] polarDecompose() {
        double[] dArray;
        int n = this.numRows;
        AbstractDoubleVector[] abstractDoubleVectorArray = new AbstractDoubleVector[n];
        try {
            dArray = LinearMath.eigenSolveSymmetric(this, abstractDoubleVectorArray);
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            return null;
        }
        double[][] dArray2 = new double[n][n];
        double[][] dArray3 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            double d = Math.abs(dArray[i]);
            dArray2[i][0] = dArray[i] * abstractDoubleVectorArray[i].getComponent(0) / d;
            dArray3[i][0] = d * abstractDoubleVectorArray[i].getComponent(0);
            for (int j = 1; j < n; ++j) {
                dArray2[i][j] = dArray[i] * abstractDoubleVectorArray[i].getComponent(j) / d;
                dArray3[i][j] = d * abstractDoubleVectorArray[i].getComponent(j);
            }
        }
        double[][] dArray4 = new double[n][n];
        double[][] dArray5 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray4[i][j] = abstractDoubleVectorArray[0].getComponent(i) * dArray2[0][j];
                dArray5[i][j] = abstractDoubleVectorArray[0].getComponent(i) * dArray3[0][j];
                for (int k = 1; k < n; ++k) {
                    double[] dArray6 = dArray4[i];
                    int n2 = j;
                    dArray6[n2] = dArray6[n2] + abstractDoubleVectorArray[k].getComponent(i) * dArray2[k][j];
                    double[] dArray7 = dArray5[i];
                    int n3 = j;
                    dArray7[n3] = dArray7[n3] + abstractDoubleVectorArray[k].getComponent(i) * dArray3[k][j];
                }
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray4), new DoubleSquareMatrix(dArray5)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleMatrix mapElements(Mapping mapping) {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = mapping.map(this.getElement(i, 0));
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = mapping.map(this.getElement(i, j));
            }
        }
        return new DoubleSquareMatrix(dArray);
    }

    private static class SquareMatrixAdaptor
    extends AbstractDoubleSquareMatrix {
        private final AbstractDoubleMatrix matrix;

        private SquareMatrixAdaptor(AbstractDoubleMatrix abstractDoubleMatrix) {
            super(abstractDoubleMatrix.rows());
            this.matrix = abstractDoubleMatrix;
        }

        public double getElement(int n, int n2) {
            return this.matrix.getElement(n, n2);
        }

        public void setElement(int n, int n2, double d) {
            this.matrix.setElement(n, n2, d);
        }
    }
}

