/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaClassRegistryChangeEvent;
import groovy.lang.MetaClassRegistryChangeEventListener;
import groovy.lang.MetaMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.reflection.GeneratedMetaMethod;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.metaclass.DefaultMetaClassInfo;
import org.codehaus.groovy.runtime.metaclass.NewInstanceMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewStaticMetaMethod;
import org.codehaus.groovy.util.FastArray;
import org.codehaus.groovy.util.ManagedLinkedList;
import org.codehaus.groovy.util.ReferenceBundle;
import org.codehaus.groovy.vmplugin.VMPluginFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaClassRegistryImpl
implements MetaClassRegistry {
    private boolean useAccessible;
    private FastArray instanceMethods = new FastArray();
    private FastArray staticMethods = new FastArray();
    private LinkedList changeListenerList = new LinkedList();
    private ManagedLinkedList metaClassInfo = new ManagedLinkedList(ReferenceBundle.getWeakBundle());
    public static final int LOAD_DEFAULT = 0;
    public static final int DONT_LOAD_DEFAULT = 1;
    private static MetaClassRegistry instanceInclude;
    private static MetaClassRegistry instanceExclude;
    private volatile MetaClassRegistry.MetaClassCreationHandle metaClassCreationHandle = new MetaClassRegistry.MetaClassCreationHandle();

    public MetaClassRegistryImpl() {
        this(0, true);
    }

    public MetaClassRegistryImpl(int loadDefault) {
        this(loadDefault, true);
    }

    public MetaClassRegistryImpl(boolean useAccessible) {
        this(0, useAccessible);
    }

    public MetaClassRegistryImpl(int loadDefault, boolean useAccessible) {
        this.useAccessible = useAccessible;
        if (loadDefault == 0) {
            Class[] staticPluginDGMs;
            Class[] pluginDGMs;
            HashMap<CachedClass, List<MetaMethod>> map = new HashMap<CachedClass, List<MetaMethod>>();
            this.registerMethods(null, true, true, map);
            Class[] additionals = DefaultGroovyMethods.additionals;
            for (int i = 0; i != additionals.length; ++i) {
                this.createMetaMethodFromClass(map, additionals[i]);
            }
            for (Class plugin : pluginDGMs = VMPluginFactory.getPlugin().getPluginDefaultGroovyMethods()) {
                this.registerMethods(plugin, false, true, map);
            }
            this.registerMethods(DefaultGroovyStaticMethods.class, false, false, map);
            for (Class plugin : staticPluginDGMs = VMPluginFactory.getPlugin().getPluginStaticGroovyMethods()) {
                this.registerMethods(plugin, false, false, map);
            }
            for (Map.Entry e : map.entrySet()) {
                CachedClass cls = (CachedClass)e.getKey();
                cls.setNewMopMethods((List)e.getValue());
            }
        }
        this.installMetaClassCreationHandle();
        MetaClass emcMetaClass = this.metaClassCreationHandle.create(ExpandoMetaClass.class, this);
        emcMetaClass.initialize();
        ClassInfo.getClassInfo(ExpandoMetaClass.class).setStrongMetaClass(emcMetaClass);
        this.addMetaClassRegistryChangeEventListener(new MetaClassRegistryChangeEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void updateConstantMetaClass(MetaClassRegistryChangeEvent cmcu) {
                ManagedLinkedList managedLinkedList = MetaClassRegistryImpl.this.metaClassInfo;
                synchronized (managedLinkedList) {
                    MetaClassRegistryImpl.this.metaClassInfo.add(cmcu.getNewMetaClass());
                    Class c = cmcu.getClassToUpdate();
                    DefaultMetaClassInfo.setPrimitiveMeta(c, cmcu.getNewMetaClass() == null);
                    try {
                        Field sdyn = c.getDeclaredField("__$stMC");
                        sdyn.setBoolean(null, cmcu.getNewMetaClass() != null);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void installMetaClassCreationHandle() {
        try {
            Class<?> customMetaClassHandle = Class.forName("groovy.runtime.metaclass.CustomMetaClassCreationHandle");
            Constructor<?> customMetaClassHandleConstructor = customMetaClassHandle.getConstructor(new Class[0]);
            this.metaClassCreationHandle = (MetaClassRegistry.MetaClassCreationHandle)customMetaClassHandleConstructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            this.metaClassCreationHandle = new MetaClassRegistry.MetaClassCreationHandle();
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Could not instantiate custom Metaclass creation handle: " + e, e);
        }
    }

    private void registerMethods(Class theClass, boolean useMethodWrapper, boolean useInstanceMethods, Map<CachedClass, List<MetaMethod>> map) {
        if (useMethodWrapper) {
            try {
                List<GeneratedMetaMethod.DgmMethodRecord> records = GeneratedMetaMethod.DgmMethodRecord.loadDgmInfo();
                for (GeneratedMetaMethod.DgmMethodRecord record : records) {
                    Class[] newParams = new Class[record.parameters.length - 1];
                    System.arraycopy(record.parameters, 1, newParams, 0, record.parameters.length - 1);
                    GeneratedMetaMethod.Proxy method = new GeneratedMetaMethod.Proxy(record.className, record.methodName, ReflectionCache.getCachedClass(record.parameters[0]), record.returnType, newParams);
                    CachedClass declClass = ((MetaMethod)method).getDeclaringClass();
                    List<MetaMethod> arr = map.get(declClass);
                    if (arr == null) {
                        arr = new ArrayList<MetaMethod>(4);
                        map.put(declClass, arr);
                    }
                    arr.add(method);
                    this.instanceMethods.add(method);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            CachedMethod[] methods;
            for (CachedMethod method : methods = ReflectionCache.getCachedClass(theClass).getMethods()) {
                NewMetaMethod metaMethod;
                CachedClass[] paramTypes;
                int mod = method.getModifiers();
                if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod) || method.getCachedMethod().getAnnotation(Deprecated.class) != null || (paramTypes = method.getParameterTypes()).length <= 0) continue;
                List<MetaMethod> arr = map.get(paramTypes[0]);
                if (arr == null) {
                    arr = new ArrayList<MetaMethod>(4);
                    map.put(paramTypes[0], arr);
                }
                if (useInstanceMethods) {
                    metaMethod = new NewInstanceMetaMethod(method);
                    arr.add(metaMethod);
                    this.instanceMethods.add(metaMethod);
                    continue;
                }
                metaMethod = new NewStaticMetaMethod(method);
                arr.add(metaMethod);
                this.staticMethods.add(metaMethod);
            }
        }
    }

    private void createMetaMethodFromClass(Map<CachedClass, List<MetaMethod>> map, Class aClass) {
        try {
            MetaMethod method = (MetaMethod)aClass.newInstance();
            CachedClass declClass = method.getDeclaringClass();
            List<MetaMethod> arr = map.get(declClass);
            if (arr == null) {
                arr = new ArrayList<MetaMethod>(4);
                map.put(declClass, arr);
            }
            arr.add(method);
            this.instanceMethods.add(method);
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public final MetaClass getMetaClass(Class theClass) {
        return ClassInfo.getClassInfo(theClass).getMetaClass();
    }

    public MetaClass getMetaClass(Object obj) {
        return ClassInfo.getClassInfo(obj.getClass()).getMetaClass(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMetaClass(Class theClass, MetaClass oldMc, MetaClass newMc) {
        ClassInfo info = ClassInfo.getClassInfo(theClass);
        MetaClass mc = null;
        info.lock();
        try {
            mc = info.getStrongMetaClass();
            info.setStrongMetaClass(newMc);
        }
        finally {
            info.unlock();
        }
        if (oldMc == null && mc != newMc || oldMc != null && mc != newMc && mc != oldMc) {
            this.fireConstantMetaClassUpdate(null, theClass, mc, newMc);
        }
    }

    @Override
    public void removeMetaClass(Class theClass) {
        this.setMetaClass(theClass, null, null);
    }

    @Override
    public void setMetaClass(Class theClass, MetaClass theMetaClass) {
        this.setMetaClass(theClass, null, theMetaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaClass(Object obj, MetaClass theMetaClass) {
        Class<?> theClass = obj.getClass();
        ClassInfo info = ClassInfo.getClassInfo(theClass);
        MetaClass oldMC = null;
        info.lock();
        try {
            oldMC = info.getPerInstanceMetaClass(obj);
            info.setPerInstanceMetaClass(obj, theMetaClass);
        }
        finally {
            info.unlock();
        }
        this.fireConstantMetaClassUpdate(obj, theClass, oldMC, theMetaClass);
    }

    public boolean useAccessible() {
        return this.useAccessible;
    }

    @Override
    public MetaClassRegistry.MetaClassCreationHandle getMetaClassCreationHandler() {
        return this.metaClassCreationHandle;
    }

    @Override
    public void setMetaClassCreationHandle(MetaClassRegistry.MetaClassCreationHandle handle) {
        if (handle == null) {
            throw new IllegalArgumentException("Cannot set MetaClassCreationHandle to null value!");
        }
        ClassInfo.clearModifiedExpandos();
        handle.setDisableCustomMetaClassLookup(this.metaClassCreationHandle.isDisableCustomMetaClassLookup());
        this.metaClassCreationHandle = handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetaClassRegistryChangeEventListener(MetaClassRegistryChangeEventListener listener) {
        LinkedList linkedList = this.changeListenerList;
        synchronized (linkedList) {
            this.changeListenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetaClassRegistryChangeEventListener(MetaClassRegistryChangeEventListener listener) {
        LinkedList linkedList = this.changeListenerList;
        synchronized (linkedList) {
            Object first = this.changeListenerList.getFirst();
            this.changeListenerList.remove(listener);
            if (this.changeListenerList.size() == 0) {
                this.changeListenerList.addFirst(first);
            }
        }
    }

    protected void fireConstantMetaClassUpdate(Object obj, Class c, MetaClass oldMC, MetaClass newMc) {
        MetaClassRegistryChangeEventListener[] listener = this.getMetaClassRegistryChangeEventListeners();
        MetaClassRegistryChangeEvent cmcu = new MetaClassRegistryChangeEvent(this, obj, c, oldMC, newMc);
        for (int i = 0; i < listener.length; ++i) {
            listener[i].updateConstantMetaClass(cmcu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaClassRegistryChangeEventListener[] getMetaClassRegistryChangeEventListeners() {
        LinkedList linkedList = this.changeListenerList;
        synchronized (linkedList) {
            return this.changeListenerList.toArray(new MetaClassRegistryChangeEventListener[this.changeListenerList.size()]);
        }
    }

    public static MetaClassRegistry getInstance(int includeExtension) {
        if (includeExtension != 1) {
            if (instanceInclude == null) {
                instanceInclude = new MetaClassRegistryImpl();
            }
            return instanceInclude;
        }
        if (instanceExclude == null) {
            instanceExclude = new MetaClassRegistryImpl(1);
        }
        return instanceExclude;
    }

    public FastArray getInstanceMethods() {
        return this.instanceMethods;
    }

    public FastArray getStaticMethods() {
        return this.staticMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterator() {
        MetaClass[] refs;
        ManagedLinkedList managedLinkedList = this.metaClassInfo;
        synchronized (managedLinkedList) {
            refs = this.metaClassInfo.toArray(new MetaClass[0]);
        }
        return new Iterator(){
            private int index = 0;
            private MetaClass currentMeta;
            private boolean hasNextCalled = false;
            private boolean hasNext = false;

            public boolean hasNext() {
                if (this.hasNextCalled) {
                    return this.hasNext;
                }
                this.hasNextCalled = true;
                if (this.index < refs.length) {
                    this.hasNext = true;
                    this.currentMeta = refs[this.index];
                    ++this.index;
                } else {
                    this.hasNext = false;
                }
                return this.hasNext;
            }

            private void ensureNext() {
                this.hasNext();
                this.hasNextCalled = false;
            }

            public Object next() {
                this.ensureNext();
                return this.currentMeta;
            }

            public void remove() {
                this.ensureNext();
                MetaClassRegistryImpl.this.setMetaClass(this.currentMeta.getTheClass(), this.currentMeta, null);
                this.currentMeta = null;
            }
        };
    }
}

