/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;
import java.awt.image.IndexColorModel;

public class RGBStackMerge
implements PlugIn {
    private static boolean staticCreateComposite = true;
    private static boolean staticKeep;
    private static boolean staticIgnoreLuts;
    private ImagePlus imp;
    private byte[] blank;
    private boolean ignoreLuts;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        this.mergeStacks();
    }

    public static ImagePlus mergeChannels(ImagePlus[] images, boolean keepSourceImages) {
        RGBStackMerge rgbsm = new RGBStackMerge();
        return rgbsm.mergeHyperstacks(images, keepSourceImages);
    }

    public void mergeStacks() {
        ImagePlus imp2;
        int i;
        boolean fourChannelRGB;
        String none;
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            this.error("No images are open.");
            return;
        }
        String[] titles = new String[wList.length + 1];
        for (int i2 = 0; i2 < wList.length; ++i2) {
            ImagePlus imp = WindowManager.getImage(wList[i2]);
            titles[i2] = imp != null ? imp.getTitle() : "";
        }
        titles[wList.length] = none = "*None*";
        boolean createComposite = staticCreateComposite;
        boolean keep = staticKeep;
        this.ignoreLuts = staticIgnoreLuts;
        if (IJ.isMacro()) {
            this.ignoreLuts = false;
            keep = false;
            createComposite = false;
        }
        GenericDialog gd = new GenericDialog("Color Merge");
        gd.addChoice("Red:", titles, titles[0]);
        gd.addChoice("Green:", titles, titles[1]);
        String title3 = titles.length > 2 && !IJ.macroRunning() ? titles[2] : none;
        gd.addChoice("Blue:", titles, title3);
        String title4 = titles.length > 3 && !IJ.macroRunning() ? titles[3] : none;
        gd.addChoice("Gray:", titles, title4);
        gd.addCheckbox("Create composite", createComposite);
        gd.addCheckbox("Keep source images", keep);
        gd.addCheckbox("Ignore source LUTs", this.ignoreLuts);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int[] index = new int[]{gd.getNextChoiceIndex(), gd.getNextChoiceIndex(), gd.getNextChoiceIndex(), gd.getNextChoiceIndex()};
        createComposite = gd.getNextBoolean();
        keep = gd.getNextBoolean();
        this.ignoreLuts = gd.getNextBoolean();
        if (!IJ.isMacro()) {
            staticCreateComposite = createComposite;
            staticKeep = keep;
            staticIgnoreLuts = this.ignoreLuts;
        }
        ImagePlus[] images = new ImagePlus[4];
        int stackSize = 0;
        int width = 0;
        int height = 0;
        int bitDepth = 0;
        int slices = 0;
        int frames = 0;
        for (int i3 = 0; i3 < 4; ++i3) {
            if (index[i3] >= wList.length) continue;
            images[i3] = WindowManager.getImage(wList[index[i3]]);
            if (width != 0) continue;
            width = images[i3].getWidth();
            height = images[i3].getHeight();
            stackSize = images[i3].getStackSize();
            bitDepth = images[i3].getBitDepth();
            slices = images[i3].getNSlices();
            frames = images[i3].getNFrames();
        }
        if (width == 0) {
            this.error("There must be at least one source image or stack.");
            return;
        }
        boolean mergeHyperstacks = false;
        for (int i4 = 0; i4 < 4; ++i4) {
            ImagePlus img = images[i4];
            if (img == null) continue;
            if (img.getStackSize() != stackSize) {
                this.error("The source stacks must have the same number of images.");
                return;
            }
            if (img.isHyperStack()) {
                CompositeImage ci;
                if (img.isComposite() && (ci = (CompositeImage)img).getMode() != 1) {
                    ci.setMode(1);
                    img.updateAndDraw();
                    if (!IJ.isMacro()) {
                        IJ.run("Channels Tool...");
                    }
                    return;
                }
                if (bitDepth == 24) {
                    this.error("Source hyperstacks cannot be RGB.");
                    return;
                }
                if (img.getNChannels() > 1) {
                    this.error("Source hyperstacks cannot have more than 1 channel.");
                    return;
                }
                if (img.getNSlices() != slices || img.getNFrames() != frames) {
                    this.error("Source hyperstacks must have the same dimensions.");
                    return;
                }
                mergeHyperstacks = true;
            }
            if (img.getWidth() != width || images[i4].getHeight() != height) {
                this.error("The source images or stacks must have the same width and height.");
                return;
            }
            if (!createComposite || img.getBitDepth() == bitDepth) continue;
            this.error("The source images must have the same bit depth.");
            return;
        }
        ImageStack[] stacks = new ImageStack[]{images[0] != null ? images[0].getStack() : null, images[1] != null ? images[1].getStack() : null, images[2] != null ? images[2].getStack() : null, images[3] != null ? images[3].getStack() : null};
        String macroOptions = Macro.getOptions();
        if (macroOptions != null && macroOptions.indexOf("gray=") == -1) {
            stacks[3] = null;
        }
        boolean bl = fourChannelRGB = !createComposite && stacks[3] != null;
        if (fourChannelRGB) {
            createComposite = true;
        }
        if (stacks[3] != null) {
            createComposite = true;
        }
        for (i = 0; i < 4; ++i) {
            if (images[i] == null || images[i].getBitDepth() != 24) continue;
            createComposite = false;
        }
        if (createComposite || mergeHyperstacks) {
            imp2 = this.mergeHyperstacks(images, keep);
            if (imp2 == null) {
                return;
            }
        } else {
            ImageStack rgb = this.mergeStacks(width, height, stackSize, stacks[0], stacks[1], stacks[2], keep);
            imp2 = new ImagePlus("RGB", rgb);
        }
        if (images[0] != null) {
            imp2.setCalibration(images[0].getCalibration());
        }
        if (!keep) {
            for (i = 0; i < 4; ++i) {
                if (images[i] == null || images[i].getWindow() == null) continue;
                images[i].changes = false;
                images[i].close();
            }
        }
        if (fourChannelRGB) {
            if (imp2.getStackSize() == 1) {
                imp2 = imp2.flatten();
                imp2.setTitle("RGB");
            } else {
                imp2.setTitle("RGB");
                IJ.run(imp2, "RGB Color", "slices");
            }
        }
        imp2.show();
    }

    public ImagePlus mergeHyperstacks(ImagePlus[] images, boolean keep) {
        ImageProcessor ip;
        int c;
        int n = images.length;
        int channels = 0;
        for (int i = 0; i < n; ++i) {
            if (images[i] == null) continue;
            ++channels;
        }
        if (channels < 2) {
            return null;
        }
        ImagePlus[] images2 = new ImagePlus[channels];
        Color[] defaultColors = new Color[]{Color.red, Color.green, Color.blue, Color.white};
        Color[] colors = new Color[channels];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            if (images[i] == null) continue;
            images2[j] = images[i];
            if (i < defaultColors.length) {
                colors[j] = defaultColors[i];
            }
            ++j;
        }
        images = images2;
        ImageStack[] stacks = new ImageStack[channels];
        for (int i = 0; i < channels; ++i) {
            ImagePlus imp2 = images[i];
            if (this.isDuplicate(i, images)) {
                imp2 = imp2.duplicate();
            }
            stacks[i] = imp2.getStack();
        }
        ImagePlus imp = images[0];
        int w = imp.getWidth();
        int h = imp.getHeight();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        ImageStack stack2 = new ImageStack(w, h);
        int[] index = new int[channels];
        for (int t = 0; t < frames; ++t) {
            for (int z = 0; z < slices; ++z) {
                for (c = 0; c < channels; ++c) {
                    ip = stacks[c].getProcessor(index[c] + 1);
                    if (keep) {
                        ip = ip.duplicate();
                    }
                    stack2.addSlice(null, ip);
                    if (keep) {
                        int n2 = c;
                        index[n2] = index[n2] + 1;
                        continue;
                    }
                    stacks[c].deleteSlice(1);
                }
            }
        }
        String title = imp.getTitle();
        title = title.startsWith("C1-") ? title.substring(3) : (frames > 1 ? "Merged" : "Composite");
        ImagePlus imp2 = new ImagePlus(title, stack2);
        imp2.setDimensions(channels, slices, frames);
        imp2 = new CompositeImage(imp2, 1);
        for (c = 0; c < channels; ++c) {
            ip = images[c].getProcessor();
            IndexColorModel cm = (IndexColorModel)ip.getColorModel();
            LUT lut = null;
            if (c < colors.length && colors[c] != null && (this.ignoreLuts || !ip.isColorLut())) {
                lut = LUT.createLutFromColor(colors[c]);
                lut.min = ip.getMin();
                lut.max = ip.getMax();
            } else {
                lut = new LUT(cm, ip.getMin(), ip.getMax());
            }
            ((CompositeImage)imp2).setChannelLut(lut, c + 1);
        }
        imp2.setOpenAsHyperStack(true);
        return imp2;
    }

    private boolean isDuplicate(int index, ImagePlus[] images) {
        boolean count = false;
        for (int i = 0; i < index; ++i) {
            if (images[index] != images[i]) continue;
            return true;
        }
        return false;
    }

    public ImagePlus createComposite(int w, int h, int d, ImageStack[] stacks, boolean keep) {
        ImagePlus[] images = new ImagePlus[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            images[i] = new ImagePlus("" + i, stacks[i]);
        }
        return this.mergeHyperstacks(images, keep);
    }

    public ImageStack mergeStacks(int w, int h, int d, ImageStack red, ImageStack green, ImageStack blue, boolean keep) {
        ImageStack rgb = new ImageStack(w, h);
        int inc = d / 10;
        if (inc < 1) {
            inc = 1;
        }
        int slice = 1;
        this.blank = new byte[w * h];
        boolean invertedRed = red != null ? red.getProcessor(1).isInvertedLut() : false;
        boolean invertedGreen = green != null ? green.getProcessor(1).isInvertedLut() : false;
        boolean invertedBlue = blue != null ? blue.getProcessor(1).isInvertedLut() : false;
        try {
            for (int i = 1; i <= d; ++i) {
                ColorProcessor cp = new ColorProcessor(w, h);
                byte[] redPixels = this.getPixels(red, slice, 0);
                byte[] greenPixels = this.getPixels(green, slice, 1);
                byte[] bluePixels = this.getPixels(blue, slice, 2);
                if (invertedRed) {
                    redPixels = this.invert(redPixels);
                }
                if (invertedGreen) {
                    greenPixels = this.invert(greenPixels);
                }
                if (invertedBlue) {
                    bluePixels = this.invert(bluePixels);
                }
                cp.setRGB(redPixels, greenPixels, bluePixels);
                if (keep) {
                    ++slice;
                } else {
                    if (red != null) {
                        red.deleteSlice(1);
                    }
                    if (green != null && green != red) {
                        green.deleteSlice(1);
                    }
                    if (blue != null && blue != red && blue != green) {
                        blue.deleteSlice(1);
                    }
                }
                rgb.addSlice(null, cp);
                if (i % inc != 0) continue;
                IJ.showProgress((double)i / (double)d);
            }
            IJ.showProgress(1.0);
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory("Merge Stacks");
            IJ.showProgress(1.0);
        }
        return rgb;
    }

    byte[] getPixels(ImageStack stack, int slice, int color) {
        if (stack == null) {
            return this.blank;
        }
        Object pixels = stack.getPixels(slice);
        if (!(pixels instanceof int[])) {
            if (pixels instanceof byte[]) {
                return (byte[])pixels;
            }
            ImageProcessor ip = stack.getProcessor(slice);
            ip = ip.convertToByte(true);
            return (byte[])ip.getPixels();
        }
        int size = stack.getWidth() * stack.getHeight();
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ColorProcessor cp = (ColorProcessor)stack.getProcessor(slice);
        cp.getRGB(r, g, b);
        switch (color) {
            case 0: {
                return r;
            }
            case 1: {
                return g;
            }
            case 2: {
                return b;
            }
        }
        return null;
    }

    byte[] invert(byte[] pixels) {
        byte[] pixels2 = new byte[pixels.length];
        System.arraycopy(pixels, 0, pixels2, 0, pixels.length);
        for (int i = 0; i < pixels2.length; ++i) {
            pixels2[i] = (byte)(255 - pixels2[i] & 0xFF);
        }
        return pixels2;
    }

    void error(String msg) {
        IJ.error("Merge Channels", msg);
    }
}

