/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.data.instance.Instance;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.gui.event.DataChangeEvent;
import adams.gui.visualization.container.ColorContainer;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.DatabaseContainer;
import adams.gui.visualization.container.NamedContainer;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import java.awt.Color;

public class InstanceContainer
extends Container
implements ColorContainer,
VisibilityContainer,
NamedContainer,
DatabaseContainer {
    private static final long serialVersionUID = 7952799099277106479L;
    protected Color m_Color;
    protected boolean m_Visible;

    public InstanceContainer(InstanceContainerManager manager, Instance data) {
        super((ContainerManager)manager, (Comparable)((Object)data));
    }

    protected void initialize() {
        super.initialize();
        this.m_Color = Color.WHITE;
        this.m_Visible = true;
    }

    public void assign(InstanceContainer c) {
        super.assign((Container)c);
        if (c instanceof InstanceContainer) {
            this.m_Updating = true;
            this.setColor(c.getColor());
            this.setVisible(c.isVisible());
            this.m_Updating = false;
        }
    }

    public void setColor(Color value) {
        this.m_Color = value;
        if (!this.m_Updating && this.getManager() != null) {
            this.getManager().notifyDataChangeListeners(new DataChangeEvent(this.getManager(), DataChangeEvent.Type.UPDATE, this.getManager().indexOf((Container)this)));
        }
    }

    public Color getColor() {
        return this.m_Color;
    }

    public void setVisible(boolean value) {
        this.m_Visible = value;
        if (!this.m_Updating && this.getManager() != null) {
            this.getManager().notifyDataChangeListeners(new DataChangeEvent(this.getManager(), DataChangeEvent.Type.VISIBILITY, this.getManager().indexOf((Container)this)));
        }
    }

    public boolean isVisible() {
        return this.m_Visible;
    }

    public void setData(Instance value) {
        this.setPayload((Comparable)((Object)value));
    }

    public Instance getData() {
        return (Instance)((Object)this.getPayload());
    }

    public void setID(String value) {
        this.getData().setID(value);
    }

    public String getID() {
        return this.getData().getID();
    }

    public String getDisplayID() {
        return this.getID().replaceAll("-weka\\.filter.*", "");
    }

    public int getDatabaseID() {
        int result = -1;
        Field field = new Field("DB-ID", DataType.NUMERIC);
        if (this.getData().hasReport() && this.getData().getReport().hasValue((AbstractField)field)) {
            result = this.getData().getReport().getDoubleValue((AbstractField)field).intValue();
        }
        return result;
    }

    public int compareTo(Container o) {
        if (o == null) {
            return 1;
        }
        InstanceContainer c = (InstanceContainer)o;
        return this.getData().compareTo((Object)c.getData());
    }

    public int hashCode() {
        return this.getData().hashCode();
    }

    public String toString() {
        return this.getData().toString();
    }
}

