/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.AbstractSpreadSheetWriter;
import java.text.DecimalFormat;

public abstract class AbstractFormattedSpreadSheetWriter
extends AbstractSpreadSheetWriter {
    private static final long serialVersionUID = -9100041207747021318L;
    protected String m_NumberFormat;
    protected transient DecimalFormat m_Formatter;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("number-format", "numberFormat", this.getDefaultNumberFormat());
    }

    protected String getDefaultNumberFormat() {
        return "";
    }

    public void setNumberFormat(String value) {
        this.m_NumberFormat = value;
        this.reset();
    }

    public String getNumberFormat() {
        return this.m_NumberFormat;
    }

    public String numberFormatTipText() {
        return "The format for the numbers (see java.text.DecimalFormat), use empty string for default 'double' output.";
    }

    protected synchronized String format(double value) {
        String result;
        if (this.m_NumberFormat.length() > 0) {
            if (this.m_Formatter == null) {
                try {
                    this.m_Formatter = new DecimalFormat(this.m_NumberFormat);
                }
                catch (Exception e) {
                    this.getSystemErr().println("Failed to initialize formatter with format '" + this.m_NumberFormat + "':");
                    this.getSystemErr().printStackTrace(e);
                    this.m_Formatter = new DecimalFormat();
                }
            }
            result = this.m_Formatter.format(value);
        } else {
            result = "" + value;
        }
        return result;
    }
}

