/*
 * Decompiled with CFR 0.152.
 */
package adams.data;

import adams.core.io.FileUtils;
import adams.data.id.DatabaseIDHandler;
import adams.data.id.IDHandler;
import java.io.File;

public class DataUtils {
    public static String createFilename(File dir, String name, String extension) {
        return DataUtils.createFilename(dir, name, null, extension);
    }

    public static String createFilename(File dir, String name, String suffix, String extension) {
        String result = dir.getAbsolutePath();
        if (dir.isDirectory()) {
            result = result + File.separator;
        }
        result = result + FileUtils.createFilename(name, "_");
        if (suffix != null) {
            result = result + suffix;
        }
        if (extension != null) {
            result = result + extension;
        }
        return result;
    }

    public static String createFilename(File dir, DatabaseIDHandler handler, String extension) {
        return DataUtils.createFilename(dir, handler, null, extension);
    }

    public static String createFilename(File dir, DatabaseIDHandler handler, String suffix, String extension) {
        return DataUtils.createFilename(dir, "" + handler.getDatabaseID(), suffix, extension);
    }

    public static String createFilename(File dir, IDHandler handler, String extension) {
        return DataUtils.createFilename(dir, handler, null, extension);
    }

    public static String createFilename(File dir, IDHandler handler, String suffix, String extension) {
        return DataUtils.createFilename(dir, handler.getID(), suffix, extension);
    }

    public static String createFilename(File dir, Object handler, String extension) {
        return DataUtils.createFilename(dir, handler, null, extension);
    }

    public static String createFilename(File dir, Object handler, String suffix, String extension) {
        String result = null;
        if (handler instanceof DatabaseIDHandler && ((DatabaseIDHandler)handler).getDatabaseID() != -1) {
            result = DataUtils.createFilename(dir, (DatabaseIDHandler)handler, suffix, extension);
        } else if (handler instanceof IDHandler && ((IDHandler)handler).getID() != null) {
            result = DataUtils.createFilename(dir, (IDHandler)handler, suffix, extension);
        }
        return result;
    }
}

