/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.option.AbstractArgumentOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.flow.core.AbstractActor;
import adams.flow.processor.AbstractModifyingProcessor;
import java.lang.reflect.Method;

public abstract class AbstractNameUpdater<T>
extends AbstractModifyingProcessor {
    private static final long serialVersionUID = 7133896476260133469L;
    protected String m_OldName;
    protected String m_NewName;

    @Override
    public abstract String globalInfo();

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("old-name", "oldName", "");
        this.m_OptionManager.add("new-name", "newName", "");
    }

    public void setOldName(String value) {
        this.m_OldName = value;
        this.reset();
    }

    public String getOldName() {
        return this.m_OldName;
    }

    public abstract String oldNameTipText();

    public void setNewName(String value) {
        this.m_NewName = value;
        this.reset();
    }

    public String getNewName() {
        return this.m_NewName;
    }

    public abstract String newNameTipText();

    protected abstract boolean isBaseClassMatch(Class var1);

    protected abstract boolean isNameMatch(T var1, String var2);

    protected abstract T getReplacement(T var1, String var2);

    protected void processArgumentOption(AbstractArgumentOption option) {
        Object current;
        if (this.isBaseClassMatch(option.getBaseClass()) && this.isNameMatch(current = option.getCurrentValue(), this.m_OldName)) {
            Method method = option.getDescriptor().getWriteMethod();
            try {
                Object replacement = this.getReplacement(current, this.m_NewName);
                if (replacement != null) {
                    method.invoke((Object)option.getOptionHandler(), replacement);
                    this.m_Modified = true;
                }
            }
            catch (Exception e) {
                this.getSystemErr().println("Failed to update property '" + option.getProperty() + "' of '" + option.getOptionHandler().getClass().getName() + "':");
                this.getSystemErr().printStackTrace(e);
            }
        }
    }

    @Override
    protected void processActor(AbstractActor actor) {
        actor.getOptionManager().traverse(new OptionTraverser(){

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
                AbstractNameUpdater.this.processArgumentOption(option);
            }

            @Override
            public boolean canRecurse(Class cls) {
                return true;
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }
        });
        if (this.m_Modified) {
            this.m_ModifiedActor = actor;
        }
    }
}

