/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.option.OptionUtils;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;

public class SetArrayElement
extends AbstractTransformer {
    private static final long serialVersionUID = -5436016357221787534L;
    protected Index m_Index;
    protected String m_Value;

    @Override
    public String globalInfo() {
        return "Picks an element from an array and forwards only this element.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", "1");
        this.m_OptionManager.add("value", "value", "");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Index = new Index();
    }

    public void setIndex(String value) {
        this.m_Index.setIndex(value);
        this.reset();
    }

    public String getIndex() {
        return this.m_Index.getIndex();
    }

    public String indexTipText() {
        return "The index of the element to set; " + this.m_Index.getExample();
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value to set in the array.";
    }

    @Override
    public String getQuickInfo() {
        String result = "Index = ";
        String variable = this.getOptionManager().getVariableForProperty("index");
        result = result + (variable == null ? this.m_Index.getIndex() : variable);
        result = result + ", Value = ";
        variable = this.getOptionManager().getVariableForProperty("value");
        result = variable != null ? result + variable : result + "\"" + this.m_Value + "\"";
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            Object[] array = (Object[])this.m_InputToken.getPayload();
            this.m_Index.setMax(array.length);
            Array.set(array, this.m_Index.getIntIndex(), OptionUtils.valueOf(array.getClass().getComponentType(), this.m_Value));
            this.m_OutputToken = new Token(array);
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }
}

