/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.PrintObject;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.TextEditorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConsolePanel
extends BasePanel
implements MenuBarProvider {
    private static final long serialVersionUID = -2339480199106797838L;
    protected static ConsolePanel m_Singleton;
    protected BaseTabbedPane m_TabbedPane;
    protected OutputPanel m_PanelAll;
    protected OutputPanel m_PanelStdOut;
    protected OutputPanel m_PanelStdErr;
    protected OutputPanel m_PanelDebug;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemSaveAs;
    protected JMenuItem m_MenuItemExit;
    protected JMenuItem m_MenuItemCopy;
    protected JMenuItem m_MenuItemClear;
    protected JMenuItem m_MenuItemLineWrap;
    protected JMenuItem m_MenuItemFind;
    protected JMenuItem m_MenuItemFindNext;

    protected ConsolePanel() {
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane();
        this.add((Component)this.m_TabbedPane, "Center");
        this.m_PanelAll = new OutputPanel("All");
        this.m_TabbedPane.addTab(this.m_PanelAll.getTitle(), this.m_PanelAll);
        this.m_PanelStdOut = new OutputPanel("StdOut");
        this.m_TabbedPane.addTab(this.m_PanelStdOut.getTitle(), this.m_PanelStdOut);
        this.m_PanelStdErr = new OutputPanel("StdErr", Color.RED.darker());
        this.m_TabbedPane.addTab(this.m_PanelStdErr.getTitle(), this.m_PanelStdErr);
        this.m_PanelDebug = new OutputPanel("Debug", Color.BLUE.darker());
        this.m_TabbedPane.addTab(this.m_PanelDebug.getTitle(), this.m_PanelDebug);
    }

    @Override
    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            JMenuBar result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            JMenuItem menuitem = new JMenuItem("Clear");
            menu.add(menuitem);
            menuitem.setMnemonic('l');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed N"));
            menuitem.setIcon(GUIHelper.getIcon("new.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConsolePanel.this.getCurrentPanel() != null) {
                        ConsolePanel.this.getCurrentPanel().clear();
                    }
                }
            });
            this.m_MenuItemClear = menuitem;
            menuitem = new JMenuItem("Save as...");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl shift pressed S"));
            menuitem.setIcon(GUIHelper.getIcon("save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConsolePanel.this.getCurrentPanel() != null) {
                        ConsolePanel.this.getCurrentPanel().saveAs();
                    }
                }
            });
            this.m_MenuItemSaveAs = menuitem;
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon("exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConsolePanel.this.closeParent();
                }
            });
            this.m_MenuItemExit = menuitem;
            menu = new JMenu("Edit");
            result.add(menu);
            menu.setMnemonic('E');
            menuitem = new JMenuItem("Copy");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed C"));
            menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConsolePanel.this.getCurrentPanel() != null) {
                        ConsolePanel.this.getCurrentPanel().copy();
                    }
                }
            });
            this.m_MenuItemCopy = menuitem;
            menuitem = new JMenuItem("Line wrap");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('L');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed L"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConsolePanel.this.getCurrentPanel() != null) {
                        ConsolePanel.this.getCurrentPanel().setLineWrap(!ConsolePanel.this.getCurrentPanel().getLineWrap());
                    }
                }
            });
            this.m_MenuItemFind = menuitem;
            menuitem = new JMenuItem("Find");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('F');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed F"));
            menuitem.setIcon(GUIHelper.getIcon("find.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConsolePanel.this.getCurrentPanel() != null) {
                        ConsolePanel.this.getCurrentPanel().find();
                    }
                }
            });
            this.m_MenuItemFind = menuitem;
            menuitem = new JMenuItem("Find next");
            menu.add(menuitem);
            menuitem.setMnemonic('N');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl shift pressed F"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConsolePanel.this.getCurrentPanel() != null) {
                        ConsolePanel.this.getCurrentPanel().findNext();
                    }
                }
            });
            this.m_MenuItemFindNext = menuitem;
            this.m_MenuBar = result;
        }
        return this.m_MenuBar;
    }

    protected OutputPanel getCurrentPanel() {
        OutputPanel result = null;
        if (this.m_TabbedPane.getSelectedComponent() instanceof OutputPanel) {
            result = (OutputPanel)this.m_TabbedPane.getSelectedComponent();
        }
        return result;
    }

    public void append(PrintObject.OutputType outputType, String msg) {
        switch (outputType) {
            case STDOUT: {
                this.m_PanelAll.append(msg);
                this.m_PanelStdOut.append(msg);
                break;
            }
            case STDERR: {
                this.m_PanelAll.append(msg);
                this.m_PanelStdErr.append(msg);
                break;
            }
            case DEBUG: {
                this.m_PanelAll.append(msg);
                this.m_PanelDebug.append(msg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled output type: " + (Object)((Object)outputType));
            }
        }
    }

    public static synchronized ConsolePanel getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new ConsolePanel();
        }
        return m_Singleton;
    }

    public static class OutputPanel
    extends BasePanel {
        private static final long serialVersionUID = 8547336176163250862L;
        protected String m_Title;
        protected boolean m_OutputEnabled;
        protected TextEditorPanel m_TextArea;
        protected JButton m_ButtonEnabledDisable;
        protected JSpinner m_SpinnerMaxLines;
        protected JButton m_ButtonClear;

        public OutputPanel(String title) {
            this(title, Color.BLACK);
        }

        public OutputPanel(String title, Color color) {
            this.m_Title = title;
            this.m_OutputEnabled = true;
            this.m_TextArea.getTextArea().setForeground(color);
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_TextArea = new TextEditorPanel();
            this.add((Component)this.m_TextArea, "Center");
            JPanel panel = new JPanel(new FlowLayout(0, 10, 0));
            panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.add((Component)panel, "South");
            this.m_ButtonEnabledDisable = new JButton("Disable");
            this.m_ButtonEnabledDisable.setMnemonic('a');
            this.m_ButtonEnabledDisable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean bl = OutputPanel.this.m_OutputEnabled = !OutputPanel.this.m_OutputEnabled;
                    if (OutputPanel.this.m_OutputEnabled) {
                        OutputPanel.this.m_ButtonEnabledDisable.setText("Disable");
                    } else {
                        OutputPanel.this.m_ButtonEnabledDisable.setText("Enable");
                    }
                }
            });
            panel.add(this.m_ButtonEnabledDisable);
            this.m_SpinnerMaxLines = new JSpinner();
            this.m_SpinnerMaxLines.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    OutputPanel.this.trimOutput();
                }
            });
            SpinnerNumberModel model = (SpinnerNumberModel)this.m_SpinnerMaxLines.getModel();
            model.setMinimum(Integer.valueOf(1));
            model.setMaximum(Integer.valueOf(1000000));
            model.setStepSize(1000);
            model.setValue(10000);
            panel.add(this.m_SpinnerMaxLines);
            this.m_ButtonClear = new JButton("Clear", GUIHelper.getIcon("new.gif"));
            this.m_ButtonClear.setMnemonic('l');
            this.m_ButtonClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OutputPanel.this.m_TextArea.clear();
                }
            });
            panel.add(this.m_ButtonClear);
        }

        public String getTitle() {
            return this.m_Title;
        }

        public void setOutputEnabled(boolean value) {
            this.m_OutputEnabled = value;
        }

        public void clear() {
            this.m_TextArea.clear();
        }

        public void copy() {
            this.m_TextArea.copy();
        }

        public void saveAs() {
            this.m_TextArea.saveAs();
        }

        public void find() {
            this.m_TextArea.find();
        }

        public void findNext() {
            this.m_TextArea.findNext();
        }

        public void setLineWrap(boolean value) {
            this.m_TextArea.setLineWrap(value);
        }

        public boolean getLineWrap() {
            return this.m_TextArea.getLineWrap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void trimOutput() {
            TextEditorPanel textEditorPanel = this.m_TextArea;
            synchronized (textEditorPanel) {
                if (this.m_TextArea.getTextArea().getLineCount() > ((Number)this.m_SpinnerMaxLines.getValue()).intValue()) {
                    StringBuilder buf = new StringBuilder(this.m_TextArea.getContent());
                    int index = buf.indexOf("\n", (int)((double)buf.length() * 0.2));
                    if (index == -1) {
                        buf = new StringBuilder();
                    } else {
                        buf.delete(0, index);
                    }
                    this.m_TextArea.setContent(buf.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void append(String msg) {
            if (!this.m_OutputEnabled) {
                return;
            }
            TextEditorPanel textEditorPanel = this.m_TextArea;
            synchronized (textEditorPanel) {
                this.m_TextArea.append(msg);
                this.trimOutput();
                this.m_TextArea.setCaretPosition(this.m_TextArea.getContent().length());
            }
        }
    }
}

