/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.base.BasePassword;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.AbstractDatabaseConnectionPanel;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingCommandCode;
import adams.gui.scripting.ScriptingEngine;

public class DatabaseConnectionPanel
extends AbstractDatabaseConnectionPanel {
    private static final long serialVersionUID = -5065572637368668864L;
    protected AbstractScriptingEngine m_ScriptingEngine;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ScriptingEngine = this.getDefaultScriptingEngine();
    }

    protected AbstractScriptingEngine getDefaultScriptingEngine() {
        return ScriptingEngine.getSingleton(this.getDefaultDatabaseConnection());
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    @Override
    protected String getTitle() {
        return "adams".toUpperCase() + "/" + "data";
    }

    @Override
    protected void doReconnect() {
        String cmd;
        this.m_ButtonConnect.setEnabled(false);
        if (this.getDatabaseConnection().isConnected()) {
            cmd = "disconnect";
            this.showStatus("Disconnecting...");
        } else {
            cmd = "connect " + this.m_TextURL.getText() + " " + this.m_TextUser.getText() + " " + new BasePassword(this.m_TextPassword.getText()).stringValue() + " " + this.m_SpinnerDebugLevel.getValue() + " " + this.m_CheckBoxConnectOnStartUp.isSelected();
            this.showStatus("Connecting...");
        }
        this.m_ScriptingEngine.add(this, cmd, new ScriptingCommandCode(){

            @Override
            public void execute() {
                DatabaseConnectionPanel.this.m_ButtonConnect.setEnabled(true);
                try {
                    if (this.hasError()) {
                        GUIHelper.showErrorMessage(DatabaseConnectionPanel.this.m_Self, this.getError());
                    } else {
                        DatabaseConnectionPanel.this.getDatabaseConnection().addConnection(DatabaseConnectionPanel.this.getDatabaseConnection().getCurrentConnection());
                        if (DatabaseConnectionPanel.this.getDatabaseConnection().getOwner() != null) {
                            DatabaseConnectionPanel.this.getDatabaseConnection().getOwner().setDefault(DatabaseConnectionPanel.this.getDatabaseConnection());
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                DatabaseConnectionPanel.this.notifyChangeListeners();
                DatabaseConnectionPanel.this.showStatus("");
                DatabaseConnectionPanel.this.update();
            }
        });
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_ScriptingEngine.getDatabaseConnection();
    }
}

