/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.AbstractDatabaseConnection;
import adams.flow.standalone.Events;
import adams.flow.standalone.GlobalActors;
import adams.flow.standalone.Standalones;
import adams.gui.application.Child;
import adams.gui.application.ChildFrame;
import adams.gui.application.ChildWindow;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import java.awt.Component;
import java.awt.Container;
import java.util.Vector;

public class FlowHelper {
    public static Tree getTree(Container cont) {
        Tree result = null;
        for (Container parent = cont; parent != null; parent = parent.getParent()) {
            Component comp;
            if (parent instanceof Child && (comp = parent instanceof ChildFrame ? ((ChildFrame)parent).getContentPane().getComponent(0) : ((ChildWindow)parent).getContentPane().getComponent(0)) instanceof FlowEditorPanel) {
                FlowEditorPanel editor = (FlowEditorPanel)comp;
                if (!editor.hasCurrentPanel()) break;
                result = editor.getCurrentPanel().getTree();
                break;
            }
            if (!(parent instanceof Container)) break;
        }
        return result;
    }

    public static boolean isFlowEdited(Container cont) {
        return FlowHelper.getTree(cont) != null;
    }

    public static Node getEditedNode(Container cont) {
        Node result = null;
        Tree tree = FlowHelper.getTree(cont);
        if (tree != null) {
            result = tree.getCurrentEditingNode();
        }
        return result;
    }

    public static Node getEditedParent(Container cont) {
        Node result = null;
        Tree tree = FlowHelper.getTree(cont);
        if (tree != null) {
            result = tree.getCurrentEditingParent();
        }
        return result;
    }

    public static adams.db.AbstractDatabaseConnection getDatabaseConnection(Container cont, Class actorCls, adams.db.AbstractDatabaseConnection defDbCon) {
        adams.db.AbstractDatabaseConnection result = null;
        Node current = FlowHelper.getEditedNode(cont);
        Node parent = current != null ? (Node)current.getParent() : FlowHelper.getEditedParent(cont);
        if (parent == null) {
            return result;
        }
        while (parent != null && result == null) {
            ActorHandler handler;
            if (parent.getActor() instanceof ActorHandler && (handler = (ActorHandler)((Object)parent.getActor())).getActorHandlerInfo().canContainStandalones()) {
                AbstractActor actor;
                block1: for (int i = 0; i < parent.getChildCount() && ActorUtils.isStandalone(actor = (current = (Node)parent.getChildAt(i)).getActor()); ++i) {
                    if (!actor.getSkip() && actor.getClass().isAssignableFrom(actorCls)) {
                        result = ((AbstractDatabaseConnection)actor).getConnection();
                        break;
                    }
                    if (!(actor instanceof Standalones)) continue;
                    for (int n = 0; n < current.getChildCount(); ++n) {
                        AbstractActor subactor = ((Node)current.getChildAt(n)).getActor();
                        if (subactor.getSkip() || !subactor.getClass().isAssignableFrom(actorCls)) continue;
                        result = ((AbstractDatabaseConnection)subactor).getConnection();
                        continue block1;
                    }
                }
            }
            parent = (Node)parent.getParent();
        }
        if (result == null) {
            result = defDbCon;
        }
        return result;
    }

    public static Vector<Node> findGlobalActors(Container cont) {
        Node current = FlowHelper.getEditedNode(cont);
        Node parent = current != null ? (Node)current.getParent() : FlowHelper.getEditedParent(cont);
        return FlowHelper.findGlobalActors(current, parent);
    }

    public static Vector<Node> findGlobalActors(Node current, Node parent) {
        Vector<Node> result = new Vector<Node>();
        if (parent == null) {
            return result;
        }
        while (parent != null) {
            ActorHandler handler;
            if (parent.getActor() instanceof ActorHandler && (handler = (ActorHandler)((Object)parent.getActor())).getActorHandlerInfo().canContainStandalones()) {
                AbstractActor actor;
                block1: for (int i = 0; i < parent.getChildCount() && ActorUtils.isStandalone(actor = (current = (Node)parent.getChildAt(i)).getActor()); ++i) {
                    if (!actor.getSkip() && actor instanceof GlobalActors) {
                        result.add(current);
                        break;
                    }
                    if (!(actor instanceof Standalones)) continue;
                    for (int n = 0; n < current.getChildCount(); ++n) {
                        AbstractActor subactor = ((Node)current.getChildAt(n)).getActor();
                        if (subactor.getSkip() || !(subactor instanceof GlobalActors)) continue;
                        result.add((Node)current.getChildAt(n));
                        continue block1;
                    }
                }
            }
            parent = (Node)parent.getParent();
        }
        return result;
    }

    public static Vector<Node> findTopGlobalActors(Container cont) {
        Node current = FlowHelper.getEditedNode(cont);
        Node parent = current != null ? (Node)current.getParent() : FlowHelper.getEditedParent(cont);
        if (parent != null) {
            parent = (Node)parent.getRoot();
        }
        return FlowHelper.findTopGlobalActors(parent);
    }

    public static Vector<Node> findTopGlobalActors(Node parent) {
        ActorHandler handler;
        Vector<Node> result = new Vector<Node>();
        if (parent == null) {
            return result;
        }
        if (parent.getActor() instanceof ActorHandler && (handler = (ActorHandler)((Object)parent.getActor())).getActorHandlerInfo().canContainStandalones()) {
            Node current;
            AbstractActor actor;
            block0: for (int i = 0; i < parent.getChildCount() && ActorUtils.isStandalone(actor = (current = (Node)parent.getChildAt(i)).getActor()); ++i) {
                if (!actor.getSkip() && actor instanceof GlobalActors) {
                    result.add(current);
                    break;
                }
                if (!(actor instanceof Standalones)) continue;
                for (int n = 0; n < current.getChildCount(); ++n) {
                    AbstractActor subactor = ((Node)current.getChildAt(n)).getActor();
                    if (subactor.getSkip() || !(subactor instanceof GlobalActors)) continue;
                    result.add((Node)current.getChildAt(n));
                    continue block0;
                }
            }
        }
        return result;
    }

    public static Vector<Node> findEvents(Container cont) {
        Node current = FlowHelper.getEditedNode(cont);
        Node parent = current != null ? (Node)current.getParent() : FlowHelper.getEditedParent(cont);
        return FlowHelper.findEvents(current, parent);
    }

    public static Vector<Node> findEvents(Node current, Node parent) {
        Vector<Node> result = new Vector<Node>();
        if (parent == null) {
            return result;
        }
        while (parent != null) {
            ActorHandler handler;
            if (parent.getActor() instanceof ActorHandler && (handler = (ActorHandler)((Object)parent.getActor())).getActorHandlerInfo().canContainStandalones()) {
                AbstractActor actor;
                block1: for (int i = 0; i < parent.getChildCount() && ActorUtils.isStandalone(actor = (current = (Node)parent.getChildAt(i)).getActor()); ++i) {
                    if (!actor.getSkip() && actor instanceof Events) {
                        result.add(current);
                        break;
                    }
                    if (!(actor instanceof Standalones)) continue;
                    for (int n = 0; n < current.getChildCount(); ++n) {
                        AbstractActor subactor = ((Node)current.getChildAt(n)).getActor();
                        if (subactor.getSkip() || !(subactor instanceof Events)) continue;
                        result.add((Node)current.getChildAt(n));
                        continue block1;
                    }
                }
            }
            parent = (Node)parent.getParent();
        }
        return result;
    }
}

