/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOption;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.TextDialog;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import adams.gui.goe.MultiSelectionEditor;
import adams.gui.goe.PropertyPanel;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PlaceholderFileEditor
extends AbstractPropertyEditorSupport
implements PropertyPanel.PopupMenuCustomizer,
CustomStringRepresentationHandler,
MultiSelectionEditor,
InlineEditorSupport {
    protected BaseFileChooser m_FileChooser;

    public static String toString(AbstractOption option, Object object) {
        return ((PlaceholderFile)object).getPath();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new PlaceholderFile(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return PlaceholderFileEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return PlaceholderFileEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        PlaceholderFile f = (PlaceholderFile)this.getValue();
        if (f == null) {
            return "null";
        }
        return "new adams.core.io.PlaceholderFile(\"" + f.getName() + "\")";
    }

    @Override
    protected JComponent createCustomEditor() {
        PlaceholderFile currentFile = (PlaceholderFile)this.getValue();
        this.m_FileChooser = currentFile != null ? new BaseFileChooser() : new BaseFileChooser(new PlaceholderFile(System.getProperty("user.dir")));
        this.m_FileChooser.setApproveButtonText("Select");
        this.m_FileChooser.setApproveButtonMnemonic('S');
        this.m_FileChooser.setMultiSelectionEnabled(false);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_FileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmdString = e.getActionCommand();
                if (cmdString.equals("ApproveSelection")) {
                    PlaceholderFile newVal = PlaceholderFileEditor.this.m_FileChooser.getSelectedPlaceholderFile();
                    PlaceholderFileEditor.this.setValue(newVal);
                    PlaceholderFileEditor.this.closeDialog(1);
                } else {
                    PlaceholderFileEditor.this.closeDialog(0);
                }
            }
        });
        return this.m_FileChooser;
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        PlaceholderFile currentFile = (PlaceholderFile)this.getValue();
        if (currentFile != null) {
            this.m_FileChooser.setSelectedFile(currentFile);
        }
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        PlaceholderFile f = (PlaceholderFile)this.getValue();
        String val = "No file";
        if (f != null) {
            val = f.getPath();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    @Override
    public boolean isInlineEditingAvailable() {
        return true;
    }

    @Override
    public void setInlineValue(String value) {
        if (this.isInlineValueValid(value)) {
            this.setValue(new PlaceholderFile(value));
        }
    }

    @Override
    public String getInlineValue() {
        return ((PlaceholderFile)this.getValue()).toString();
    }

    @Override
    public boolean isInlineValueValid(String value) {
        return PlaceholderFile.isValid(value);
    }

    @Override
    public Object[] getSelectedObjects() {
        Component comp = this.getCustomEditor();
        this.initForDisplay();
        BaseFileChooser chooser = new BaseFileChooser(new PlaceholderFile(System.getProperty("user.dir")));
        chooser.setApproveButtonText("Select");
        chooser.setApproveButtonMnemonic('S');
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(0);
        int retVal = chooser.showOpenDialog(comp.getParent());
        Object[] result = retVal == 0 ? chooser.getSelectedPlaceholderFiles() : new PlaceholderFile[]{};
        return result;
    }

    @Override
    public void customizePopup(final BasePanel owner, JPopupMenu menu) {
        JMenuItem menuitem = new JMenuItem("Open in text editor...");
        menuitem.setIcon(GUIHelper.getIcon("open.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextDialog dialog = owner.getParentDialog() != null ? new TextDialog(owner.getParentDialog()) : new TextDialog(owner.getParentFrame());
                dialog.setSize(600, 600);
                dialog.setContent(Utils.flatten(FileUtils.loadFromFile((PlaceholderFile)PlaceholderFileEditor.this.getValue()), "\n"));
                dialog.setLocationRelativeTo(dialog.getOwner());
                dialog.setVisible(true);
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
    }
}

