/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security.token;

import java.util.Map;
import java.util.TreeMap;
import javax.crypto.SecretKey;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;

public class JobTokenSecretManager
extends SecretManager<JobTokenIdentifier> {
    private final SecretKey masterKey = this.generateSecret();
    private final Map<String, SecretKey> currentJobTokens = new TreeMap<String, SecretKey>();

    public static SecretKey createSecretKey(byte[] key) {
        return SecretManager.createSecretKey(key);
    }

    public static byte[] computeHash(byte[] msg, SecretKey key) {
        return JobTokenSecretManager.createPassword(msg, key);
    }

    @Override
    public byte[] createPassword(JobTokenIdentifier identifier) {
        byte[] result = JobTokenSecretManager.createPassword(identifier.getBytes(), this.masterKey);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTokenForJob(String jobId, Token<JobTokenIdentifier> token) {
        SecretKey tokenSecret = JobTokenSecretManager.createSecretKey(token.getPassword());
        Map<String, SecretKey> map = this.currentJobTokens;
        synchronized (map) {
            this.currentJobTokens.put(jobId, tokenSecret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTokenForJob(String jobId) {
        Map<String, SecretKey> map = this.currentJobTokens;
        synchronized (map) {
            this.currentJobTokens.remove(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretKey retrieveTokenSecret(String jobId) throws SecretManager.InvalidToken {
        SecretKey tokenSecret = null;
        Map<String, SecretKey> map = this.currentJobTokens;
        synchronized (map) {
            tokenSecret = this.currentJobTokens.get(jobId);
        }
        if (tokenSecret == null) {
            throw new SecretManager.InvalidToken("Can't find job token for job " + jobId + " !!");
        }
        return tokenSecret;
    }

    @Override
    public byte[] retrievePassword(JobTokenIdentifier identifier) throws SecretManager.InvalidToken {
        return this.retrieveTokenSecret(identifier.getJobId().toString()).getEncoded();
    }

    @Override
    public JobTokenIdentifier createIdentifier() {
        return new JobTokenIdentifier();
    }
}

