/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.impl.MetricsRecordBuilderImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;

class MetricsBuilderImpl
extends ArrayList<MetricsRecordBuilderImpl>
implements MetricsBuilder {
    private static final long serialVersionUID = 1L;
    private MetricsFilter recordFilter;
    private MetricsFilter metricFilter;

    MetricsBuilderImpl() {
    }

    @Override
    public MetricsRecordBuilderImpl addRecord(String name) {
        boolean acceptable = this.recordFilter == null || this.recordFilter.accepts(name);
        MetricsRecordBuilderImpl rb = new MetricsRecordBuilderImpl(name, this.recordFilter, this.metricFilter, acceptable);
        if (acceptable) {
            this.add(rb);
        }
        return rb;
    }

    public List<MetricsRecordImpl> getRecords() {
        ArrayList<MetricsRecordImpl> records = new ArrayList<MetricsRecordImpl>(this.size());
        for (MetricsRecordBuilderImpl rb : this) {
            MetricsRecordImpl mr = rb.getRecord();
            if (mr == null) continue;
            records.add(mr);
        }
        return records;
    }

    MetricsBuilderImpl setRecordFilter(MetricsFilter rf) {
        this.recordFilter = rf;
        return this;
    }

    MetricsBuilderImpl setMetricFilter(MetricsFilter mf) {
        this.metricFilter = mf;
        return this;
    }
}

