/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.text;

import de.intarsys.pdf.content.text.CSTextSearchHit;
import de.intarsys.pdf.content.text.CSTextSearcher;
import java.awt.geom.Rectangle2D;

public class CSTextSearchCandidate {
    private final CSTextSearchHit hit = new CSTextSearchHit();
    private final CSTextSearcher searcher;
    private int index = 0;
    private char[] suffix = new char[CSTextSearcher.FLOATING_CONTEXT_LENGTH];
    private int suffixPos = 0;

    public CSTextSearchCandidate(CSTextSearcher searcher) {
        this.searcher = searcher;
    }

    public boolean accept(char c, Rectangle2D charRect) {
        char currentChar = this.searcher.basicGetSearchString().charAt(this.index);
        char checkChar = c;
        if (this.searcher.isIgnoreCase()) {
            checkChar = Character.toLowerCase(c);
        }
        if (currentChar == checkChar) {
            this.hit.add(c, charRect);
            ++this.index;
            return true;
        }
        return false;
    }

    public boolean acceptSuffix(char c) {
        this.suffix[this.suffixPos++] = c;
        if (this.suffixPos >= CSTextSearcher.FLOATING_CONTEXT_LENGTH) {
            this.flush();
            return false;
        }
        return true;
    }

    public void flush() {
        this.hit.setSuffix(new String(this.suffix, 0, this.suffixPos));
    }

    public CSTextSearchHit getHit() {
        return this.hit;
    }

    public boolean isComplete() {
        return this.index >= this.searcher.basicGetSearchString().length();
    }

    public void setPrefix(String prefix) {
        this.hit.setPrefix(prefix);
    }

    public void setSuffix(String suffix) {
        this.hit.setSuffix(suffix);
    }
}

