/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.histogram;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayHistogram;
import adams.gui.event.PaintListener;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.stats.histogram.HistogramOptions;
import adams.gui.visualization.stats.histogram.HistogramPanel;
import adams.gui.visualization.stats.paintlet.HistogramPaintlet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import weka.core.Instances;

public class Histogram
extends PaintablePanel {
    private static final long serialVersionUID = -4366437103496819542L;
    protected Instances m_Instances;
    protected HistogramPanel m_Plot;
    protected HistogramPaintlet m_Val;
    protected HistogramOptions m_HistOptions;
    protected int m_Index;

    public void setOptions(HistogramOptions val) {
        this.m_HistOptions = val;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void prepareUpdate() {
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null;
    }

    public void reset() {
        this.m_Val = this.m_HistOptions.m_Val;
        ArrayHistogram aHist = new ArrayHistogram();
        double[] data = this.m_Instances.attributeToDoubleArray(this.m_Index);
        Serializable[] numData = new Number[data.length];
        for (int i = 0; i < data.length; ++i) {
            numData[i] = Double.valueOf(data[i]);
        }
        aHist.add(numData);
        aHist.setBinWidth(this.m_HistOptions.m_WidthBin);
        aHist.setNumBins(this.m_HistOptions.m_NumBins);
        ArrayHistogram.BinCalculation bc = this.m_HistOptions.m_BoxType.toString() == "DENSITY" ? ArrayHistogram.BinCalculation.DENSITY : ArrayHistogram.BinCalculation.MANUAL;
        aHist.setBinCalculation(bc);
        AbstractArrayStatistic.StatisticContainer cont = aHist.calculate();
        int numBins = (Integer)cont.getMetaData("num-bins");
        double[] binX = (double[])cont.getMetaData("bin-x");
        double binWidth = (Double)cont.getMetaData("bin-width");
        double[][] plotdata = new double[numBins][2];
        for (int i = 0; i < plotdata.length; ++i) {
            plotdata[i][1] = (Double)cont.getCell(0, i);
            plotdata[i][0] = binX[i];
        }
        this.m_Val.setData(plotdata, binWidth, this.m_Instances.attribute(this.m_Index).name());
        this.m_Val.setPanel(this);
        this.repaint();
        this.revalidate();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Val = new HistogramPaintlet();
        this.m_Plot = new HistogramPanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        this.add((Component)((Object)this.m_Plot), "Center");
        this.repaint();
    }

    public void setIndex(int val) {
        this.m_Index = val;
    }
}

